%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSLサイトよりファイルをダウンロードする
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  ssl_client_connect,socket_ssl_download,ssl_socket_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーへHTTP接続を行う                          %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_client_connect('127.0.0.1','443','RSA',S),
	P1='GET /test.tgz HTTP/1.1',
	name(C,[10]),
	atom_concat(P1,C,P2),
	atom_concat(P2,'Host: 127.0.0.1',P3),
	atom_concat(P3,C,P4),
	atom_concat(P4,'Connection: Close',P5),
	atom_concat(P5,C,P6),
	atom_concat(P6,C,Get),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーへGET命令を送信し、ダウンロードを行う     %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_socket_send(S,Get),
	socket_ssl_download(S, 'test.tgz'),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーの切断を行う                              %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    ssl_socket_close(S).

