#ifndef	H_AZPROLOG_H
#define	H_AZPROLOG_H
/*  AZPROLOG.H Version 2.0 Compile Code/C Code Header File 1990 8 6 */
/*  AZPROLOG.H Version 6.0 Compile Code/C Code Header File 2009 11 18 */
/*  AZPROLOG.H Version 7.0 Compile Code/C Code Header File 2011 12 08 */

/* CAUTION
   azprolo.h is generated from tmpl.azprolog.h.
   Don't edit azprolog.h by hand.
 */
#define AZ_POINTER_SIZE   32

#include <setjmp.h>

#ifdef WIN32
#	define AZlongjmp(a,b)	longjmp((_JBTYPE *)a,b)
#	define AZsetjmp(a)	setjmp((_JBTYPE *)a)
#else
//	define AZlongjmp(a,b)	longjmp(a,b)   /* 2013.10.21 */ 
#	define AZlongjmp(a,b)	longjmp((struct __jmp_buf_tag *)a,b)
#	define AZsetjmp(a)	setjmp((struct __jmp_buf_tag *)a)
#endif

#define AZ_MAX_ATOM_LENGTH         0xffff    /* 2013.10.30 */
 
#if AZ_POINTER_SIZE == 64
typedef long long		SBASEINT;
typedef unsigned long long	BASEINT;
typedef unsigned short		F_BASECHAR;
typedef unsigned int		F_BASESHORT;
#else 
typedef int			SBASEINT;
typedef unsigned int		BASEINT;
typedef unsigned char		F_BASECHAR;
typedef unsigned short		F_BASESHORT;
#endif

typedef unsigned char		BASECHAR;
typedef unsigned short		BASESHORT;

typedef void			*(*(*pred)())();

#ifndef	lint
#	define DET_SUCC	((pred)(BASEINT)1)
#endif

#ifndef lint
#	define	INTERNAL	static
#	define	YIELD(r)	return	(pred)((BASEINT)(r))
#	define	CUT_RETURN(p,v)	AZlongjmp(BODY(p), v)
#	define	NULLFRAME	((Frame*)0)
#endif

#define FAIL			((pred)0)
#define ATOM_NIL		(1L)

#define AZ_ENC_SJIS     (0)
#define AZ_ENC_EUCJP    (1)
#define AZ_ENC_UTF8     (2)


#ifndef AZ_BIG_ENDIAN
struct _TPAIR {F_BASECHAR d, v;};
#else
struct _TPAIR {F_BASECHAR v, d;};
#endif

typedef struct _TERM {
	union {struct _TERM *p; BASEINT i;}	b;
#ifndef AZ_BIG_ENDIAN
	union {F_BASESHORT e; struct _TPAIR s;}	t;
	F_BASESHORT	n;
#else
	F_BASESHORT	n;
	union {F_BASESHORT e; struct _TPAIR s;}	t;
#endif
} TERM;

typedef struct _UTERM {
	BASEINT		body;
	F_BASESHORT	no;
	F_BASESHORT	tag;
} UTERM;

#define TAG(term)		((term)->t.s.d + 0)
#define SETTAG(term, tag)	((term)->t.e = tag)
#define GVCLEAR(term)		((term)->t.e = undef_tag)
#define NO(term)		((term)->n)
#define BODY(term)		((term)->b.p)
#define INT_BODY(term)		((term)->b.i)

#define	DSHIFT		(2)
#define link_tag	(0 << DSHIFT)
#define undef_tag	(1 << DSHIFT)
#define int_tag		(2 << DSHIFT)
#define float_tag	(3 << DSHIFT)
#define atom_tag	(4 << DSHIFT)
#define term_tag	(5 << DSHIFT)
#define list_tag	(6 << DSHIFT)
#define gterm_tag	(7 << DSHIFT)
#define glist_tag	(8 << DSHIFT)
#define fh_tag		(9 << DSHIFT)
#define array_tag	(10 << DSHIFT)
#define lvar_tag	(11 << DSHIFT)
#define clp_tag		(12 << DSHIFT)
#define var_tag		(13 << DSHIFT)

#define REALVALUE(item)	\
	while (TAG(item) == link_tag || TAG(item) == clp_tag )   \
		(item) = BODY(item)

#define IS_INT(term)	(TAG(term) == int_tag)
#define IS_ATOM(term)	(TAG(term) == atom_tag)
#define IS_FLOAT(term)	(TAG(term) == float_tag)
#define IS_LIST(term)	(TAG(term) == list_tag || TAG(term) == glist_tag)
#define IS_TERM(term)	(TAG(term) == term_tag || TAG(term) == gterm_tag)
#define IS_UNDEF(term)	(TAG(term) == undef_tag)
#define	IS_ARRAY(term)	(TAG(term) == array_tag)
#define	IS_CLP(term)	(TAG(term) == clp_tag)
#define	IS_FH(term)	(TAG(term) == fh_tag)

#ifndef MSDOS
#	define	HP_LT(a,b)	((a)< (b))
#	define	HP_LE(a,b)	((a)<=(b))
#	define	HP_GT(a,b)	((a)> (b))
#	define	HP_GE(a,b)	((a)>=(b))
#	define	HP_EQ(a,b)	((a)==(b))
#	define	HP_NE(a,b)	((a)!=(b))
#else
#	define	HP_LT(a,b)	((long)(a)< (long)(b))
#	define	HP_LE(a,b)	((long)(a)<=(long)(b))
#	define	HP_GT(a,b)	((long)(a)> (long)(b))
#	define	HP_GE(a,b)	((long)(a)>=(long)(b))
#	define	HP_EQ(a,b)	((long)(a)==(long)(b))
#	define	HP_NE(a,b)	((long)(a)!=(long)(b))
#endif

typedef struct _Frame
{
	struct _Frame	*Link;
	pred		(*Cont)();
	struct _Frame	*Env;
	TERM		*Local;
	TERM		*Global;
	TERM		**Trail;
	int		nVars;
	BASESHORT	ip;
	BASESHORT	cont_ip;
	TERM		*Bdefine;
} Frame;

#ifndef  lint

typedef struct INDEX_TABLE {
	BASEINT	atom;
	BASEINT	arity; 
	BASEINT	casev;
}	*IndexPtr;

#define IndexTable  struct INDEX_TABLE


typedef struct _BBLTN {
	char	*name;
	BASEINT	atomNo;
	int		arity;
	pred		(*proc)();
} BBLTN;

#define CALL_PRED(prd, cont, env, now, rc)				\
	now.Cont = cont;	now.Env = env;				\
	rc = prd(&now);							\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			if ((rc = (*now.Cont)(now.Env, &now)) == FAIL)	\
				break;					\
	  	}							\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_PRED(my_function, cont, env, now, rc)   		\
	now.Cont = cont;	now.Env = env;				\
	rc = my_function;						\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL) 	\
				break;					\
		}							\
	  	rc = (pred)(*rc)(&now);					\
	}

#define CALL_PRED_DET(prd, cont, cont1,env, now, rc)			\
	now.Cont = cont;	now.Env = env;				\
	rc = prd(&now);							\
	while ( rc != DET_SUCC || now.Cont != cont1) {			\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
		if(rc == FAIL) YIELD(FAIL);				\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_PRED_DET(my_function, cont, cont1,env, now, rc)		\
	now.Cont = cont;	now.Env = env;				\
	rc = my_function;						\
	while ( rc != DET_SUCC || now.Cont != cont1) {	  		\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
		if(rc == FAIL) YIELD(FAIL);				\
		rc = (pred)(*rc)(&now);					\
	}

#define CALL_PRED_FF(prd, cont, env, now, rc)		   		\
	now.Cont = cont;	now.Env = env;			  	\
	if ((rc = prd(&now)) == FAIL)				   	\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)  		\
			YIELD(FAIL);					\
	}

#define B1_CALL_PRED_FF(my_function, cont, env, now, rc)  		\
	now.Cont = cont;	now.Env = env;				\
	if ((rc = my_function) == FAIL)					\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)		 	\
			YIELD(FAIL);					\
	}

#define B1_CALL_PRED_FF2(my_function,now,rc)  				\
	if ((rc = my_function) == FAIL)					\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)		 	\
			YIELD(FAIL);					\
	}


#define CALL_CDET(prd, env, rc, fail_label)				\
	rc = prd(env);							\
	while (rc != FAIL && rc != DET_SUCC){		   		\
		rc  = (pred)(*rc)(env);				 	\
	}								\
	if( rc == FAIL ) fail_label

#define CALL_LASTGOAL(prd, env, now, rc)				\
	now.cont_ip = env->cont_ip;					\
	now.Cont = env->Cont;	now.Env = env->Env;			\
	rc = prd(&now);							\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL)	\
				break;					\
	  	}							\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_LASTGOAL(my_function, env, now, rc)			\
	now.cont_ip = env->cont_ip;	  				\
	now.Cont = env->Cont;	now.Env = env->Env;			\
	rc = my_function;						\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL) 	\
				break;					\
	  	}							\
	  	rc = (pred)(*rc)(&now);					\
	}

#define CALL_CONT(env, now, rc)						\
	now.cont_ip = env->cont_ip;	   				\
	rc = (*env->Cont)(env->Env, &now);				\
	while (rc != FAIL) {						\
		rc = (pred)(*rc)(&now);					\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
	}

#endif

/* Set Environment Frame */ 

#define LINK0(fp)							\
	if (HP_GE(next_var_cell, var_bottom))				\
		LocalOverflow();					\
	fp->Local = next_var_cell

#define LINK1(fp, vmax, vars)						\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	next_gvar_cell += (fp->nVars = vars)

#define LINK1Z(fp, vmax)						\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	fp->nVars = 0

#define LINK1ZZ(fp)							\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	fp->nVars = 0

#define RELINK0(fp)							\
	while (HP_GT(trail_register, fp->Trail))			\
		(*(--trail_register))->t.s.d = undef_tag;		\
	next_var_cell = fp->Local

#define RESET_GLOBAL(fp,vars)						\
	next_gvar_cell = fp->Global + (fp->nVars = vars)

#define INDX_GOTO(Call_by_value,Call_by_var) \
{ if(value_or_var) Call_by_value; else Call_by_var; }

#define SWITCH_ON_LIST_NIL_VAR(CheckTerm,IFlist,IFnil,IFvar,Other)	\
{  TERM *a=CheckTerm;					 	\
   Switch_Head:								\
   switch(TAG(a)){							\
	case link_tag:  a=BODY(a); goto Switch_Head;			\
	case undef_tag: IFvar;						\
	case atom_tag:  if(INT_BODY(a) == ATOM_NIL ) IFnil; else Other; \
	case list_tag:							\
	case glist_tag: IFlist;						\
	default:	Other; } }
	  


#define RELINK(fp, vars)						\
	while (HP_GT(trail_register, fp->Trail))		  	\
		(*(--trail_register))->t.s.d = undef_tag;	 	\
	next_var_cell = fp->Local;					\
	next_gvar_cell = fp->Global + (fp->nVars = vars)

#define RELINKZ(fp)							\
	while (HP_GT(trail_register, fp->Trail))		  	\
		(*(--trail_register))->t.s.d = undef_tag;	 	\
	next_var_cell = fp->Local;					\
	next_gvar_cell = fp->Global;					\
	fp->nVars = 0

/* Data Set To Argument Buffer */
/*	if (TAG(item) == undef_tag) {   2013.10.09 Telly  */

#define PUTVAL(item, place)						\
	if (TAG(item) == undef_tag || TAG(item)==clp_tag) {		\
		SETTAG(place, link_tag);				\
		BODY(place) = item;					\
	} else								\
		*(place) = *(item)

#define PUTVARC(item, place)						\
	SETTAG(item,undef_tag);						\
	SETTAG(place, link_tag);					\
	BODY(place) = item

#define PUTVAR(item, place)						\
	SETTAG(place, link_tag);					\
	BODY(place) = item

#define PUTARG(item, place)						\
	*(place) = *(item)

#define GETGLOBAL(fp, lhv, n)						\
	lhv = next_gvar_cell;						\
	if (HP_GE(next_gvar_cell += n, gvar_bottom))			\
		lhv = MakeRoom1(fp, n)

#define PUTNIL(s)	SETTAG(s, atom_tag);		  		\
			INT_BODY(s) = ATOM_NIL


#define PUTINT(i,s)	SETTAG(s, int_tag);				\
			INT_BODY(s) = (BASEINT)i

#define PUTATOM(i,s)	SETTAG(s, atom_tag);	   			\
			INT_BODY(s) = (BASEINT)(i)

#define PUTGROUND(i,s)  *(s) = *(TERM *)(i)

#define PUTVALD(s, d)							\
	if (TAG(s) == undef_tag) {					\
		SETTAG(d, link_tag);					\
		BODY(d) = (s);					 	\
	} else {							\
		*(d) = *(s);						\
	}								\
	(s) = (d)

#define PUTRVALD(a, d)							\
	for (; ; ) {							\
		switch (TAG(a)) {					\
		case undef_tag: SETTAG(d, link_tag);	  		\
				BODY(d) = (a);				\
				break;					\
		case link_tag:	(a) = BODY(a);		   		\
				continue;				\
		case float_tag:	SETTAG((d), float_tag); 		\
				BODY(d) = (d) + 1;			\
				*((d) + 1) = *BODY(a);			\
				*((d) + 2) = *(BODY(a) + 1);		\
				break;					\
		default:	*(d) = *(a);				\
				break;					\
		}							\
		break;							\
	}								\
	(a) = (d)


#define BytePredDefine(name,add)		\
	pred name(Env)				\
	Frame *Env;				\
	{ Env->ip=add; Env->Bdefine=(TERM *)user_atom; return bytecall(Env);}

/*	DECLARATIONS	*/
struct WKSIZE {
	BASEINT a, c, ar, h, l, g, t;
};

#ifdef	DLL
#define	AZ_EXTERN	extern __declspec(dllimport)
#else
#define	AZ_EXTERN extern
#endif

AZ_EXTERN struct _BBLTN *built_table;
AZ_EXTERN struct _TERM	*gvar_bottom, *var_bottom;
AZ_EXTERN struct _TERM	*next_gvar_cell, *next_var_cell;
AZ_EXTERN struct _TERM	**trail_register;
AZ_EXTERN struct WKSIZE	wksize;

#ifndef	DLL
#define	SET_WKSIZE	struct WKSIZE wksize 
#else
#define	SET_WKSIZE	void init_wksize(void) { extern struct WKSIZE _wksize; wksize = *(struct WKSIZE*)&_wksize;} \
			struct WKSIZE _wksize
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* function prototype */
/* arity */
pred	P2_current_pred(Frame*);
pred	P2_clause(Frame*);
pred	P1_retract(Frame*);
pred	P1_nospy(Frame*);
pred	P1_spy(Frame*);
pred	P0_listing(Frame*);
pred	P1_listing(Frame*);
pred	P0_s_new(Frame*);
pred	P2_abolish(Frame*);
pred	P2_s_mode(Frame*);
pred	P3_retract(Frame*);
pred	P3_clause(Frame*);
pred	P4_clause(Frame*);
pred	P2_s_sort(Frame*);
pred	P3_get_call_count(Frame*);
pred	P0_reset_call_count(Frame*);
pred	P1_reset_call_count(Frame*);
pred	P2_reset_call_count(Frame*);
	
void	put_bltn(char *string, int arity, pred func());
int	spy(BASEINT Atom_No, int Do1, int Do2, int Arity);
int	B2_s_mode(Frame*, TERM*, TERM*);
int	B3_clause(Frame*, TERM*, TERM*, TERM*);
int	B4_clause(Frame*, TERM*, TERM*, TERM*, TERM*);
int	B2_s_sort(Frame*, TERM*, TERM*);
int	B3_retract(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B1_nospy(Frame *Env, TERM *arg1);
int	B1_spy(Frame *Env, TERM *arg1);
int	B1_listing(Frame *Env, TERM *arg1);
int	B2_abolish(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_get_call_count(Frame*, TERM*, TERM*, TERM*);
int	B1_reset_call_count(Frame*, TERM*);
int	B2_reset_call_count(Frame*, TERM*, TERM*);

/* assert */
pred	P1_assert(Frame*);
pred	P1_assertz(Frame*);
pred	P2_assert(Frame*);
pred	P1_asserta(Frame*);
pred	P2_assert_commit_mode(Frame*);
int	B1_assert(Frame*, TERM*);
int	B1_assertz(Frame*, TERM*);
int	B1_asserta(Frame*, TERM*);
int	B2_assert(Frame*, TERM*, TERM*);
int	B2_assert_commit_mode(Frame*, TERM*, TERM*);

/* atomman */
pred	P1_current_atom(Frame *Env);
pred	P3_current_op(Frame *Env);
pred	P3_op(Frame *Env);
pred	P2_atom(Frame *Env);
pred	P2_s_atom(Frame *Env);
pred	P2_prompt(Frame *Env);
pred	P2_name(Frame *Env);
pred	P3_atom_append(Frame *Env);
pred	P2_term_atom(Frame *Env);
BASEINT	PutAtom(Frame *Env, char *string);
void	PutOperator(Frame *Env, BASESHORT precedence, BASESHORT optype, char *string);

int	B3_op(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_atom(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_s_atom(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_prompt(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_name(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_atom_append(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_term_atom(Frame *Env, TERM *arg1, TERM *arg2);

int az_get_atom_length(BASEINT number);
int az_get_atom_term_length(Frame* Env, TERM* t);

/* azpi */
pred	P1_call(Frame *Env);
pred	P1_leash(Frame *Env);
pred	P1_leash1(Frame *Env);
pred	P1_leash2(Frame *Env);
pred	call(Frame *Env);
pred	dCall(Frame *Env);
pred	nComma(Frame *Env);
pred	dComma(Frame *Env);
pred	nSemi(Frame *Env);
pred	dSemi(Frame *Env);
pred	P0_debug(Frame *Env);
pred	P0_trace(Frame *Env);
pred	P0_notrace(Frame *Env);
pred	P0_nodebug(Frame *Env);
pred	P0_debugging(Frame *Env);
int	B1_leash(Frame *Env, TERM *arg1);
int	B1_leash2(Frame *Env, TERM *arg1);
int	B1_leash1(Frame *Env, TERM *arg1);

/* azpi/caller */
pred	comma(Frame *Env);
pred	semi(Frame *Env);

/* bload */
pred	P1_b_load(Frame *Env);
pred	P9_b_load(Frame *Env);

/* builtin */
void	builtin_all(void);
void	user_file(void);

/* bytecall */
pred	bytecall(Frame *Env);
void	byte_set_user_heap(UTERM *heap, UTERM *heap0, UTERM *atom, int size);
void	byte_set_user_atom(UTERM *arry, int size);
pred	P3_sort_byte_index(Frame *Env);
pred	P3_sort_byte_index2(Frame *Env);
pred	P6_set_byte_module(Frame *Env);
pred	P3_set_byte_heap(Frame *Env);
pred	P_bytecall(Frame *Env);
void	init_copy_byte_set_user_atom(UTERM array[], UTERM init_array[], int size);
void	init_copy_byte_set_user_heap(UTERM array[], UTERM init_array[], int size);

/* caller */
pred	B1_call(Frame *Env, BASEINT functor, int arity, TERM* arg, ...);

/* compare */
pred	eqterm(Frame *Env);
pred	noteqterm(Frame *Env);
pred	gtterm(Frame *Env);
pred	geterm(Frame *Env);
pred	ltterm(Frame *Env);
pred	leterm(Frame *Env);
pred	P3_compare(Frame *Env);
pred	P0_sh(Frame *Env);
pred	P1_system(Frame *Env);
pred	P2_system(Frame *Env);
pred	P2_getenv(Frame *Env);
pred	P1_random_seed(Frame *Env);
pred	P2_s_random(Frame *Env);
pred	P2_s_randomize(Frame *Env);
pred	P2_system(Frame *Env);

int	B_gtterm(Frame *Env, TERM *arg1, TERM *arg2);
int	B_geterm(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_compare(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B1_system(Frame *Env, TERM *arg1);
int	B2_system(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_getenv(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_random_seed(Frame *Env, TERM *arg1);
int	B2_s_random(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_s_randomize(Frame *Env, TERM *arg1, TERM *arg2);
int	B_eqterm(Frame *Env, TERM *arg1, TERM *arg2);
int	B_noteqterm(Frame *Env, TERM *arg1, TERM *arg2);
int	B_ltterm(Frame *Env, TERM *arg1, TERM *arg2);
int	B_leterm(Frame *Env, TERM *arg1, TERM *arg2);

/* compute2 */
int	s_add(Frame* Env, TERM* Ans, int n, ...);
int	s_mlt(Frame* Env, TERM* Ans, int n, ...);
int	s_sub(Frame* Env, TERM* Ans, int n, ...);
int	s_div(Frame* Env, TERM* Ans, int n, ...);
int	s_sub_eval_eq(TERM* Ans, int n, ...);
int	s_sub_eval_noteq(TERM* Ans, int n, ...);
int	s_add_eval_eq(TERM* Ans, int n, ...);
int	s_add_eval_noteq(TERM* Ans, int n, ...);
int	s_calc_eval_comp(TERM* Ans,int preds,int mytype,int n, ...);
int	s_add1(Frame *Env, TERM *Ans, TERM *Term, BASEINT Int);
int	s_mlt1(Frame *Env, TERM *Ans, TERM *Term, BASEINT Int);
int	s_sub1(Frame *Env, TERM *Ans, TERM *Term, BASEINT Int);
int	s_sub2(Frame *Env, TERM *Ans, BASEINT Int, TERM *Term);
int	s_div1(Frame *Env, TERM *Ans, TERM *Term, BASEINT Int);
int	s_div2(Frame *Env, TERM *Ans, BASEINT Int, TERM *Term);
int	sc_ncomp(TERM *Term, BASEINT Int, int n);
int	sfc_ncomp(TERM *Term, double Float, int n);
int	s_dec(Frame *Env, TERM *Ans, TERM *Term);
int	s_inc(Frame *Env, TERM *Ans, TERM *Term);
int	s_left_shift(Frame *Env, TERM *Ans, TERM *Term, TERM *Term2);
int	s_calc_by_typeE(Frame *Env, TERM *Ans, TERM *Term, TERM *Term2, int Type);
int	s_calc_int_by_typeE(Frame *Env, TERM *Ans, TERM *Term, BASEINT w, int Type);

#define	s_calc_by_type(a,b,c,d)		s_calc_by_typeE(Env,a,b,c,d)
#define	s_calc_int_by_type(a,b,c,d)	s_calc_int_by_typeE(Env,a,b,c,d)

/* curses/terminal */
pred	P0_d_clear(Frame *Env);
pred	P0_d_cleol(Frame *Env);
pred	P0_d_cleos(Frame *Env);
pred	P1_d_cursor(Frame *Env);
pred	P2_d_cursor(Frame *Env);
pred	P1_d_keyback(Frame *Env);
pred	P2_d_pos(Frame *Env);
pred	P2_d_screen(Frame *Env);
pred	P2_d_scroll(Frame *Env);
pred	P0_d_redisp(Frame *Env);
pred	P1_d_keyin(Frame *Env);
pred	P1_d_keylength(Frame *Env);
pred	P1_d_keypeek(Frame *Env);
int	B1_d_keyin(Frame *Env, TERM *arg1);
int	B1_d_cursor(Frame *Env, TERM *arg1);
int	B2_d_cursor(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_d_keyback(Frame *Env, TERM *arg1);
int	B2_d_pos(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_d_screen(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_d_scroll(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_d_keylength(Frame *Env, TERM *arg1);
int	B1_d_keypeek(Frame *Env, TERM *arg1);

/* dbase */
pred	P1_d_open(Frame *Env);
pred	P1_d_close(Frame *Env);
pred	P1_d_opening(Frame *Env);
pred	P2_d_create(Frame *Env);
pred	P2_d_struct(Frame *Env);
pred	P4_d_record(Frame *Env);
pred	P3_d_seek(Frame *Env);
pred	P2_d_read(Frame *Env);
pred	P3_d_read(Frame *Env);
pred	P3_d_write(Frame *Env);
pred	P3_d_writeq(Frame *Env);
int	B1_d_open(Frame *Env, TERM *arg1);
int	B1_d_close(Frame *Env, TERM *arg1);
int	B1_d_opening(Frame *Env, TERM *arg1);
int	B2_d_create(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_d_struct(Frame *Env, TERM *arg1, TERM *arg2);
int	B4_d_record(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4);
int	B3_d_seek(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_d_read(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_d_read(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_d_write(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_d_writeq(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_d_write_1(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, int f);


/* edit */
pred	P0_e_edit(Frame *Env);
pred	P2_e_edit(Frame *Env);
pred	P0_e_init(Frame *Env);
pred	P1_e_init(Frame *Env);
pred	P2_e_init(Frame *Env);
pred	P1_e_dline(Frame *Env);
pred	P0_e_end(Frame *Env);
pred	P2_e_bell(Frame *Env);
pred	P0_e_refresh(Frame *Env);
pred	P1_e_forward(Frame *Env);
pred	P1_e_backward(Frame *Env);
pred	P0_e_echo(Frame *Env);
pred	P1_e_echo(Frame *Env);
pred	P1_e_alpha(Frame *Env);
pred	P1_e_digit(Frame *Env);
pred	P1_e_space(Frame *Env);
pred	P1_e_lower(Frame *Env);
pred	P2_e_lower(Frame *Env);
pred	P1_e_upper(Frame *Env);
pred	P2_e_upper(Frame *Env);
pred	P1_e_kanji(Frame *Env);
pred	P1_e_kanji1(Frame *Env);
pred	P1_e_kanji2(Frame *Env);
pred	P1_e_kana(Frame *Env);
pred	P1_e_insert(Frame *Env);
pred	P0_e_disp(Frame *Env);
pred	P1_e_pos(Frame *Env);
pred	P2_e_pos(Frame *Env);
pred	P1_e_repos(Frame *Env);
pred	P0_e_new(Frame *Env);
pred	P1_e_char(Frame *Env);
pred	P0_e_next(Frame *Env);
pred	P0_e_previous(Frame *Env);
pred	P0_e_bob(Frame *Env);
pred	P0_e_eob(Frame *Env);
pred	P1_e_eob(Frame *Env);
pred	P0_e_bol(Frame *Env);
pred	P0_e_eol(Frame *Env);
pred	P1_e_bol(Frame *Env);
pred	P1_e_eol(Frame *Env);
pred	P1_e_down(Frame *Env);
pred	P1_e_up(Frame *Env);
pred	P1_e_mark(Frame *Env);
pred	P0_e_mark(Frame *Env);
pred	P0_e_markend(Frame *Env);
pred	P1_e_jump(Frame *Env);
pred	P1_e_nword(Frame *Env);
pred	P1_e_pword(Frame *Env);
pred	P1_e_delete(Frame *Env);
pred	P1_e_kill(Frame *Env);
pred	P0_e_kill(Frame *Env);
pred	P0_e_yank(Frame *Env);
pred	P2_e_bothcase(Frame *Env);
pred	P1_e_fsearch(Frame *Env);
pred	P1_e_bsearch(Frame *Env);
pred	P2_e_change(Frame *Env);
pred	P1_e_create(Frame *Env);
pred	P0_e_free(Frame *Env);
pred	P1_e_getbs(Frame *Env);

int	B2_e_edit(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_init(Frame *Env, TERM *arg1);
int	B2_e_init(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_dline(Frame *Env, TERM *arg1);
int	B2_e_bell(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_forward(Frame *Env, TERM *arg1);
int	B1_e_backward(Frame *Env, TERM *arg1);
int	B1_e_echo(Frame *Env, TERM *arg1);
int	B1_e_alpha(Frame *Env, TERM *arg1);
int	B1_e_digit(Frame *Env, TERM *arg1);
int	B1_e_space(Frame *Env, TERM *arg1);
int	B1_e_lower(Frame *Env, TERM *arg1);
int	B2_e_lower(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_upper(Frame *Env, TERM *arg1);
int	B2_e_upper(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_kanji(Frame *Env, TERM *arg1);
int	B1_e_kanji1(Frame *Env, TERM *arg1);
int	B1_e_kanji2(Frame *Env, TERM *arg1);
int	B1_e_kana(Frame *Env, TERM *arg1);
int	B1_e_insert(Frame *Env, TERM *arg1);
int	B1_e_pos(Frame *Env, TERM *arg1);
int	B2_e_pos(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_repos(Frame *Env, TERM *arg1);
int	B1_e_char(Frame *Env, TERM *arg1);
int	B1_e_eob(Frame *Env, TERM *arg1);
int	B1_e_bol(Frame *Env, TERM *arg1);
int	B1_e_eol(Frame *Env, TERM *arg1);
int	B1_e_down(Frame *Env, TERM *arg1);
int	B1_e_up(Frame *Env, TERM *arg1);
int	B1_e_mark(Frame *Env, TERM *arg1);
int	B1_e_jump(Frame *Env, TERM *arg1);
int	B1_e_nword(Frame *Env, TERM *arg1);
int	B1_e_pword(Frame *Env, TERM *arg1);
int	B1_e_delete(Frame *Env, TERM *arg1);
int	B1_e_kill(Frame *Env, TERM *arg1);
int	B2_e_bothcase(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_fsearch(Frame *Env, TERM *arg1);
int	B1_e_bsearch(Frame *Env, TERM *arg1);
int	B2_e_change(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_e_create(Frame *Env, TERM *arg1);
int	B1_e_getbs(Frame *Env, TERM *arg1);

/* etc */
pred	P0_halt(Frame *Env);
pred	P1_get_parameter(Frame *Env);
pred	P1_halt(Frame *Env);
pred	P2_errormode(Frame *Env);
pred	P2_s_verbos(Frame *Env);
pred	P0_statistics(Frame *Env);
pred	P4_s_version(Frame *Env);
pred	P3_s_divide_float(Frame *Env);
pred	P0_repeat(Frame *Env);
pred	P1_repeat(Frame *Env);
int	B1_halt(Frame *Env, TERM *arg1);
int	B1_get_parameter(Frame *Env, TERM *arg1);
int	B2_s_verbos(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_s_divide_float(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_errormode(Frame *Env, TERM *arg1, TERM *arg2);
int	B4_s_version(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4);

/* eval */
pred	S2_catch(Frame *Env);
pred	S2_errorset(Frame *Env);
pred	P2_errorset(Frame *Env);
pred	P0_reset_statistics(Frame *Env);
pred	P2_catch(Frame *Env);
pred	arrow(Frame *Env);
pred	negate(Frame *Env);
pred	P0_true(Frame *Env);
pred	P0_fail(Frame *Env);
pred	P1_error(Frame *Env);
pred	P0_abort(Frame *Env);
pred	P1_throw(Frame *Env);
pred	P2_unknown(Frame *Env);
pred	P1_consult(Frame *Env);
pred	P1_reconsult(Frame *Env);
pred	P0_e_consult(Frame *Env);
pred	P0_e_reconsult(Frame *Env);
pred	cut(Frame *Env);
int	B1_error(Frame *Env, TERM *arg1);
int	B1_throw(Frame *Env, TERM *arg1);
int	B2_unknown(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_consult(Frame *Env, TERM *arg1);
int	B1_reconsult(Frame *Env, TERM *arg1);

/* file */
pred	P1_see(Frame *Env);
pred	P1_tell(Frame *Env);
pred	P1_tella(Frame *Env);
pred	P0_seen(Frame *Env);
pred	P0_told(Frame *Env);
pred	P0_fileerrors(Frame *Env);
pred	P0_nofileerrors(Frame *Env);
pred	P2_fileerrors(Frame *Env);
pred	P1_seeing(Frame *Env);
pred	P1_telling(Frame *Env);
pred	P0_nl(Frame *Env);
pred	P1_nl(Frame *Env);
pred	P0_ttynl(Frame *Env);
pred	P0_log(Frame *Env);
pred	P0_flush_log(Frame *Env);
pred	P0_nolog(Frame *Env);
pred	P1_log(Frame *Env);
pred	P1_logging(Frame *Env);
pred	P1_put(Frame *Env);
pred	P2_put(Frame *Env);
pred	P1_ttyput(Frame *Env);
pred	P1_get(Frame *Env);
pred	P2_get(Frame *Env);
pred	P1_get0(Frame *Env);
pred	P2_get0(Frame *Env);
pred	P1_get1(Frame *Env);
pred	P2_get1(Frame *Env);
pred	P1_ttyget(Frame *Env);
pred	P1_ttyget0(Frame *Env);
pred	P0_copy0(Frame *Env);
pred	P0_copy1(Frame *Env);
pred	P1_skip(Frame *Env);
pred	P1_ttyskip(Frame *Env);
pred	P1_tab(Frame *Env);
pred	P2_tab(Frame *Env);
pred	P2_see(Frame *Env);
pred	P2_tell(Frame *Env);
pred	P2_tella(Frame *Env);
pred	P1_seen(Frame *Env);
pred	P1_told(Frame *Env);
pred	P2_write(Frame *Env);
pred	P2_writeq(Frame *Env);
pred	P2_read(Frame *Env);
pred	P2_current_fp(Frame *Env);
pred	P2_seek(Frame *Env);
pred	P2_listing(Frame *Env);
pred	P2_rename(Frame *Env);
int	B1_see(Frame *Env, TERM *arg1);
int	B1_tell(Frame *Env, TERM *arg1);
int	B1_tella(Frame *Env, TERM *arg1);
int	B2_fileerrors(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_seeing(Frame *Env, TERM *arg1);
int	B1_telling(Frame *Env, TERM *arg1);
int	B1_nl(Frame *Env, TERM *arg1);
int	B1_log(Frame *Env, TERM *arg1);
int	B1_logging(Frame *Env, TERM *arg1);
int	B1_put(Frame *Env, TERM *arg);
int	B2_put(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_ttyput(Frame *Env, TERM *arg);
int	B1_get(Frame *Env, TERM *arg);
int	B2_get(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_get0(Frame *Env, TERM *arg);
int	B2_get0(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_get1(Frame *Env, TERM *arg);
int	B2_get1(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_ttyget(Frame *Env, TERM *arg);
int	B1_ttyget0(Frame *Env, TERM *arg);
int	B1_skip(Frame *Env, TERM *arg1);
int	B1_ttyskip(Frame *Env, TERM *arg1);
int	B1_tab(Frame *Env, TERM *arg1);
int	B2_tab(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_see(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_tell(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_tella(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_seen(Frame *Env, TERM *arg1);
int	B1_told(Frame *Env, TERM *arg1);
int	B2_write(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_writeq(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_read(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_current_fp(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_seek(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_listing(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_rename(Frame *Env, TERM *arg1, TERM *arg2);

/* funccall */
pred	P5_s_child(Frame *Env);
pred	P3_s_wait(Frame *Env);
pred	P2_s_kill(Frame *Env);
pred	P1_s_sleep(Frame *Env);
pred	P1_s_usleep(Frame *Env);
pred	P1_s_pid(Frame *Env);
pred	P1_set_exit_timer(Frame *Env);
pred	P2_rm_builtin(Frame *Env);
pred	P0_s_flush(Frame *Env);
pred	P2_s_can_read(Frame *Env);
pred	P1_s_can_read(Frame *Env);
int	B1_s_pid(Frame *Env, TERM *arg1);
int	B5_s_child(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5);
int	B3_s_wait(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_s_kill(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_s_sleep(Frame *Env, TERM *arg1);
int	B1_s_usleep(Frame *Env, TERM *arg1);
int	B1_s_pid(Frame *Env, TERM *arg1);
int	B1_set_exit_timer(Frame *Env, TERM *arg);
int	B2_rm_builtin(Frame *Env, TERM *arg1, TERM *arg2);
int	B0_s_flush(Frame *Env);
int	B2_s_can_read(Frame *Env, TERM *arg, TERM *arg2);
int	B1_s_can_read(Frame *Env, TERM *arg);
int	B1_get_runtime(Frame *Env, TERM *arg);

/* ggc */
pred	P0_s_greclaim(Frame *Env);
void	MakeRoom(Frame *Env, int nVars);
TERM	*MakeRoom1(Frame *Env, int nVars);

/* hgc */
pred	P0_s_reclaim(Frame *Env);

/* iso_buil */
pred	P2_keysort(Frame *Env);
pred	P2_sort(Frame *Env);
pred	P3_append(Frame *Env);
pred	P2_member(Frame *Env);
pred	P1_retractall(Frame *Env);
pred	P1_ensure_loaded(Frame *Env);
pred	P2_statistics(Frame *Env);
pred	P1_get_runtime(Frame *Env);
pred	B1_retractall(Frame *Env, TERM *arg);
pred	B1_ensure_loaded(Frame *Env, TERM *arg);
pred	B2_statistics(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_get_runtime(Frame *Env, TERM *arg);

/* interf */
int	IsAtom(TERM *term);
int	IsInt(TERM *term);
int	IsDouble(TERM *term);
int	IsUndef(TERM *term);
int	IsCons(TERM *term);
int	IsNil(TERM *term);
int	IsCompTerm(TERM *term);
BASEINT	GetAtom(TERM *t);
BASEINT	GetInt(TERM *t);
BASEINT	GetEvalInt(TERM *t);
double	GetDouble(TERM *t);
int	GetFunctor(TERM *t, BASEINT *f);
void	GetArg(TERM *t, int n);
void	GetCons(TERM *t);

int	UnifyE(Frame *Env, TERM *t1, TERM *t2);
int	UnifyIntE(Frame *Env, TERM *arg, BASEINT number);
int	UnifyAtomE(Frame *Env, TERM *arg, BASEINT number);
#define	Unify(a,b)	UnifyE(Env,a,b)
#define	UnifyInt(a,b)	UnifyIntE(Env,a,b)
#define	UnifyAtom(a,b)	UnifyAtomE(Env,a,b)

int	UnifyDouble(Frame *Env, TERM *t1, double f);
int	UnifyCompTerm(Frame* Env, TERM* Dist, BASEINT functor, int arity, ...);
int	UnifyCons(Frame *Env, TERM *t1, TERM *car, TERM *cdr);
void	MakeUndef(Frame *Env);
void	Atom2Asciz(BASEINT atom, char *buff);
BASEINT	Asciz2Atom(Frame *Env, char *name);

/* kabapred */
pred	P4_g_screen(Frame *Env);
pred	P0_g_color(Frame *Env);
pred	P2_g_color(Frame *Env);
pred	P3_g_color(Frame *Env);
pred	P6_g_box(Frame *Env);
pred	P5_g_boxfill(Frame *Env);
pred	P6_g_line(Frame *Env);
pred	P2_g_linestyle(Frame *Env);
pred	P5_g_circle(Frame *Env);
pred	P4_g_paint(Frame *Env);
pred	P3_g_point(Frame *Env);
pred	P3_g_pset(Frame *Env);
pred	P2_g_origin(Frame *Env);
pred	P6_g_view(Frame *Env);
pred	P0_g_cls(Frame *Env);
pred	P1_g_color_mode(Frame *Env);
int	B4_g_screen(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4);
int	B2_g_color(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_g_color(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B6_g_box(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6);
int	B5_g_boxfill(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5);
int	B6_g_line(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6);
int	B2_g_linestyle(Frame *Env, TERM *arg1, TERM *arg2);
int	B5_g_circle(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5);
int	B4_g_paint(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4);
int	B3_g_point(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_g_pset(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_g_origin(Frame *Env, TERM *arg1, TERM *arg2);
int	B6_g_view(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6);
int	B1_g_color_mode(Frame *Env, TERM *arg1);

/* main */
int	Parent_top_level(Frame *Env);
int	az_normalize_path(char* path, int len);
char*	az_add_os_depend_dir_sep(char* path, int len);
int	az_get_install_base_dir(char* buf, int buf_size);
int	B1_get_install_base_dir(Frame* Env, TERM* arg1);
pred	P1_get_install_base_dir(Frame *Env);
int	B1_get_install_base_dir_normalized(Frame* Env, TERM* arg1);
pred	P1_get_install_base_dir_normalized(Frame *Env);
pred	P0_break(Frame *Env);
pred	P0_unbreak(Frame *Env);
pred	P1_unbreak(Frame *Env);
int	B1_unbreak(Frame *Env, TERM *arg1);
int	az_init(int argc, char **argv);
int	az_end(void);
int	az_exec(char *goal);
int	az_exec_unify(char *goal , int n, ...);


/* meta */
pred	P1_atom(Frame *Env);
pred	P1_atomic(Frame *Env);
pred	P1_float(Frame *Env);
pred	P1_integer(Frame *Env);
pred	P1_number(Frame *Env);
pred	P1_list(Frame *Env);
pred	P1_compound(Frame *Env);
pred	P1_var(Frame *Env);
pred	P1_nonvar(Frame *Env);
pred	P2_length(Frame *Env);
pred	univ(Frame *Env);
pred	P3_functor(Frame *Env);
pred	P3_arg(Frame *Env);
int	B1_atom(Frame *Env, TERM *arg1);
int	B1_atomic(Frame *Env, TERM *arg1);
int	B1_float(Frame *Env, TERM *arg1);
int	B1_integer(Frame *Env, TERM *arg1);
int	B1_number(Frame *Env, TERM *arg1);
int	B1_list(Frame *Env, TERM *arg1);
int	B1_compound(Frame *Env, TERM *arg1);
int	B1_var(Frame *Env, TERM *arg1);
int	B1_nonvar(Frame *Env, TERM *arg1);
int	B2_length(Frame *Env, TERM *arg1, TERM *arg2);
int	B_univ(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_functor(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_arg(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);

/* numeric */
pred	eqnum(Frame *Env);
pred	noteqnum(Frame *Env);
pred	ltnum(Frame *Env);
pred	gtnum(Frame *Env);
pred	lenum(Frame *Env);
pred	genum(Frame *Env);
pred	P2_is(Frame *Env);
int	B_eqnum(Frame *Env, TERM *arg1, TERM *arg2);
int	B_noteqnum(Frame *Env, TERM *arg1, TERM *arg2);
int	B_ltnum(Frame *Env, TERM *arg1, TERM *arg2);
int	B_gtnum(Frame *Env, TERM *arg1, TERM *arg2);
int	B_lenum(Frame *Env, TERM *arg1, TERM *arg2);
int	B_genum(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_is(Frame *Env, TERM *arg1, TERM *arg2);

/* read */
pred	P1_read(Frame *Env);
pred	P2_char_conversion(Frame *Env);
pred	P2_current_char_conv(Frame *Env);
int 	PutCharConv(unsigned pn1, unsigned pn2);
int	B1_read(Frame *Env, TERM *arg1);
int	B2_char_conversion(Frame *Env, TERM *arg2, TERM *arg1);

/* register */
pred	P3_a_register(Frame *Env);
pred	P3_e_register(Frame *Env);
pred	P3_f_register(Frame *Env);
pred	P3_e_switch(Frame *Env);
pred	P2_echo(Frame *Env);
pred	P2_kanji_mode(Frame *Env);
pred	P3_array_register(Frame *Env);
int	B3_a_register(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_e_register(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_f_register(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_e_switch(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_echo(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_kanji_mode(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_array_register(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);

/* save */
pred	P1_save(Frame *Env);
pred	P1_restore(Frame *Env);
int	B1_save(Frame *Env, TERM *arg1);
int	B1_restore(Frame *Env, TERM *arg1);

/* tools */
pred	P2_s_mStackSize(Frame *Env);
pred	P2_create_array(Frame *Env);
pred	P3_create_array(Frame *Env);
pred	P3_set_array(Frame *Env);
pred	P3_get_array(Frame *Env);
pred	P4_create_neuron(Frame *Env);
pred	P5_create_neuron(Frame *Env);
pred	P7_learn_neuron(Frame *Env);
pred	P6_learn_neuron(Frame *Env);
pred	P2_save_neuron(Frame *Env);
pred	P3_add_neuron(Frame *Env);
pred	P2_copy_neuron(Frame *Env);
pred	P2_load_neuron(Frame *Env);
pred	P3_inference_neuron(Frame *Env);
pred	P1_destroy_neuron(Frame *Env);
pred	P2_fuzzy_call(Frame *Env);
pred	P1_get_leash(Frame *Env);
pred	P1_get_leash1(Frame *Env);
pred	P2_g_getdefault(Frame *Env);
pred	P2_g_default(Frame *Env);
pred	P2_g_seedefault(Frame *Env);
pred	P2_g_setdefault(Frame *Env);
int	B2_s_mStackSize(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_create_array(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_create_array(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_set_array(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_get_array(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B4_create_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4);
int	B5_create_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5);
int	B7_learn_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6, TERM *arg7);
int	B6_learn_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6);
int	B2_save_neuron(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_add_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_copy_neuron(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_load_neuron(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_inference_neuron(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B1_destroy_neuron(Frame *Env, TERM *arg);
int	B2_fuzzy_call(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_get_leash(Frame *Env, TERM *arg);
int	B1_get_leash1(Frame *Env, TERM *arg);
int	B2_g_getdefault(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_g_default(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_g_seedefault(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_g_setdefault(Frame *Env, TERM *arg1, TERM *arg2);

/* type */
pred	P2_s_charset(Frame *Env);
int	B2_s_charset(Frame *Env, TERM *arg1, TERM *arg2);
extern int az_charsetmode(void);    /* 0:sjis,1:euc,2:utf8     2013.10.30 */
extern int az_enc_len(int encode, const unsigned char* p);
extern int az_enc_len_utf8(const unsigned char* p);
extern int az_enc_len_eucjp(const unsigned char* p);
extern int az_enc_len_sjis(const unsigned char* p);

/* unify */
struct _Stream;

pred	equal(Frame *Env);
pred	not_unify(Frame *Env);
int	B_equal(Frame *Env, TERM *arg1, TERM *arg2);
int	B_not_unify(Frame *Env, TERM *arg1, TERM *arg2);
int	unifyE(Frame *Env, TERM *arg1, TERM *arg2);
int	unify_atomE(Frame *Env, TERM *arg, BASEINT atom);
int	unify_nilE(Frame *Env, TERM *arg);
int	unify_intE(Frame *Env, TERM *arg, SBASEINT val);
int	unify_fhE(Frame *Env, TERM *arg, struct _Stream *val);
int	unify_arrayE(Frame *Env, TERM *arg, TERM *val);

#define	unify(a,b)		unifyE(Env,a,b)
#define	unify_atom(a,b)		unify_atomE(Env,a,b)
#define	unify_nil(a)		unify_nilE(Env,a)
#define	unify_int(a,b)		unify_intE(Env,a,b)
#define	unify_fh(a,b)		unify_fhE(Env,a,b)
#define	unify_array(a,b)	unify_arrayE(Env,a,b)

/* utility */
int	az_list_len(TERM* t);
int	az_cstring_to_list(Frame* Env, const char *s, int len, TERM* t);
int	az_term_to_cstring_length(Frame* Env, TERM* arg);
int	az_term_to_cstring(Frame* Env, TERM* arg, char* buf, int bufsize);

pred	S0_cut(Frame *Env, Frame *Now);
pred	S0_fail(void);
pred	S0_true(void);
pred	P3_get_builtin(Frame *Env);
int	GetFlatListE(Frame *Env, TERM* arg, unsigned int n, ...);
int	GetNListE(Frame *Env, TERM* arg, unsigned int n, TERM* cdr, ...);
int	UnifyFlatListE(Frame *Env, TERM* arg, unsigned int n, ...);
int	UnifyListE(Frame *Env, TERM *arg, TERM *car, TERM *cdr);
int	UnifyNListE(Frame *Env, TERM* arg, unsigned int n, TERM* cdr, ...);
int	UnifyNList2E(Frame *Env, TERM* arg, unsigned int n, TERM* cdr, ...);
int	UnifyNListGetCdrE(Frame *Env, TERM* arg, unsigned int n, TERM* cdr, ...);
int	GetTermE(Frame *Env, TERM* arg, BASEINT functor, unsigned int arity, ...);
int	UnifyTermE(Frame *Env, TERM* arg, BASEINT functor, unsigned int arity, ...);
int	GetCarUnifyCdrE(Frame *Env, TERM *arg, TERM *car, TERM *cdr);
int	UnifyAtomCarOverWriteCdrE(Frame *Env, TERM *arg, BASEINT car);
int	UnifyAtomCarGetCdrE(Frame *Env, TERM *arg, BASEINT car, TERM *cdr);
int	GetCarOverWriteCdrE(Frame *Env, TERM *arg, TERM *car);
int	OverWriteCarGetCdrE(Frame *Env, TERM *arg, TERM *cdr);
int	GetListE(Frame *Env, TERM *arg, TERM *car, TERM *cdr);
int	GetCarSelfE(Frame *Env, TERM *arg);
int	GetCar1E(Frame *Env, TERM *arg1, TERM *arg2);
int	GetCdrSelfE(Frame *Env, TERM *arg);
int	UnifyCarE(Frame *Env, TERM *arg, TERM *car);
int	UnifyCar1E(Frame *Env, TERM *arg, TERM *car);
int	UnifyCdrE(Frame *Env, TERM *arg, TERM *cdr);
int	DoListE(Frame *Env, TERM *arg);
int	DoList1E(Frame *Env, TERM *arg);
int	OverWriteCarUnifyCdrE(Frame *Env, TERM *arg, TERM *cdr);
int	UnifyCarOverWriteCdrE(Frame *Env, TERM *arg, TERM *car);
int	UnifyNilE(Frame *Env, TERM *arg);
int	GetCommonCarListsE(Frame *Env, TERM *a, TERM *b);
int	UnifyCarGetCdrE(Frame *Env, TERM *arg, TERM *car, TERM *cdr);
int	GetCarE(Frame *Env, TERM *arg1, TERM *arg2);
int	GetCdrE(Frame *Env, TERM *arg1, TERM *arg2);
int	GetCarSelf1E(Frame *Env, TERM *arg);

#define	GetFlatList(a,b,...)		GetFlatListE(Env,a,b,__VA_ARGS__)
#define	GetNList(a,b,c,...)		GetNListE(Env,a,b,c,__VA_ARGS__)
#define	UnifyFlatList(a,b,...)		UnifyFlatListE(Env,a,b,__VA_ARGS__)
#define	UnifyList(a,b,c)		UnifyListE(Env,a,b,c)
#define	UnifyNList(a,b,c,...)		UnifyNListE(Env,a,b,c,__VA_ARGS__)
#define	UnifyNList2(a,b,c,...)		UnifyNList2E(Env,a,b,c,__VA_ARGS__)
#define	UnifyNListGetCdr(a,b,c,...)	UnifyNListGetCdrE(Env,a,b,c,__VA_ARGS__)
#define	GetTerm(a,b,c,...)		GetTermE(Env,a,b,c,__VA_ARGS__)
#define	UnifyTerm(a,b,c,...)		UnifyTermE(Env,a,b,c,__VA_ARGS__)
#define	GetCarUnifyCdr(a,b,c)		GetCarUnifyCdrE(Env,a,b,c)
#define	UnifyAtomCarOverWriteCdr(a,b)	UnifyAtomCarOverWriteCdrE(Env,a,b)
#define	UnifyAtomCarGetCdr(a,b,c)	UnifyAtomCarGetCdrE(Env,a,b,c)
#define	GetCarOverWriteCdr(a,b)		GetCarOverWriteCdrE(Env,a,b)
#define	OverWriteCarGetCdr(a,b)		OverWriteCarGetCdrE(Env,a,b)
#define	GetList(a,b,c)			GetListE(Env,a,b,c)
#define	GetCarSelf(a)			GetCarSelfE(Env,s)
#define	GetCar1(a,b)			GetCar1E(Env,a,b)
#define	GetCdrSelf(a)			GetCdrSelfE(Env,a)
#define	UnifyCar(a,b)			UnifyCarE(Env,a,b)
#define	UnifyCar1(a,b)			UnifyCar1E(Env,a,b)
#define	UnifyCdr(a,b)			UnifyCdrE(Env,a,b)
#define	DoList(a)			DoListE(Env,a)
#define	OverWriteCarUnifyCdr(a,b)	OverWriteCarUnifyCdrE(Env,a,b)
#define	UnifyCarOverWriteCdr(a,b)	UnifyCarOverWriteCdrE(Env,a,b)
#define	UnifyNil(a)			UnifyNilE(Env,a)
#define	GetCommonCarLists(a,b)		GetCommonCarListsE(Env,a,b)
#define	UnifyCarGetCdr(a,b,c)		UnifyCarGetCdrE(Env,a,b,c)
#define	GetCar(a,b)			GetCarE(Env,a,b)
#define	GetCdr(a,b)			GetCdrE(Env,a,b)
#define	GetCarSelf1(a)			GetCarSelf1E(Env,a)

void	PutTerm(Frame* Env, TERM* Dist, BASEINT functor, unsigned int arity, ...);
void	PutNList(Frame* Env, TERM* Dist, unsigned int n, TERM* Cdr, ...);
int	CompareValue(TERM *arg, BASEINT value);
int	IsIntOf(TERM *arg, BASEINT number);
int	IsAtomOf(TERM *arg, BASEINT number);
void	PutStructure(Frame *vEnv, Frame *Now, int Offset, TERM *hTerm, TERM *Target);
void	PutList(Frame *Env, TERM *Car, TERM *Cdr, TERM *Dist);
void	Put1List(Frame *Env, TERM *Car, TERM *Dist);
void	PutVarC(TERM *s, TERM *d);
void	S_PUTVAL(TERM *item,TERM *place);
void	GvClears(TERM *t, unsigned n);
void	S_LINK0(Frame *fp);
void	S_LINK(Frame *fp, int vmax, int vars);
void	S_LINK1(Frame *fp, int vmax, int vars);
void	S_LINK1Z(Frame *fp, int vmax);
void	S_LINK1ZZ(Frame *fp);
void	S_RELINKZ(Frame *fp);
void	S_RELINK(Frame *fp, int vars);
void	set_user_heap(UTERM *heap, UTERM *heap0, BASEINT *atom, int size);
void	set_user_atom(BASEINT *arry, int size);
void	sort_index_table(IndexPtr ip, BASEINT nelt);
int	find_atom_index(IndexPtr ip, TERM *arg, int size);
int	find_term_index(IndexPtr ip, TERM *arg, int size);
int	GetCommonCarLists2(Frame *Env, TERM *arg1, TERM *arg2);
int	get_intcar_with_overwrite(TERM *arg, BASEINT *car);
int	get_list_pointer(TERM *arg, TERM **car, TERM **cdr);
int	get_car_with_overwrite(TERM **arg, TERM **car);
int	copy_list(Frame *Env, TERM **arg1, TERM **arg2);
int	inc(TERM *X);
int	dec(TERM *X);
void	LocalOverflow(void);
void	TrailOverflow(void);
void	ArgError(void);
int	byte_debug(Frame *Env);
int	sss_find_index(IndexPtr ip, int size, BASEINT value,  int Else);
int	ss_find_int_index(IndexPtr ip, TERM *arg, int size, int myelse);
int	ss_find_atom_index(IndexPtr ip, TERM *arg, int size, int myelse);
int	ss_find_term_index(IndexPtr ip, TERM *arg, int size, int myelse);
int	ss_find_index(IndexPtr ip1, IndexPtr ip2, IndexPtr ip3, int size1, int size2, int size3, TERM *arg, int myelse);
int	ss_find_ia_index(IndexPtr ip1, IndexPtr ip2, int size1, int size2, TERM *arg, int myelse);
int	ss_find_it_index(IndexPtr ip1, IndexPtr ip2, int size1, int size2, TERM *arg, int myelse);
int	ss_find_at_index(IndexPtr ip1, IndexPtr ip2, int size1, int size2, TERM *arg, int myelse);
void	sort_index_table2(IndexPtr ip, BASEINT nelt);
extern	void set_index_table();
void	init_copy_set_user_atom(char *array[], const char *init_array[], int size);
void	init_copy_set_user_heap(UTERM array[], UTERM init_array[], int size);
void	init_copy_set_index_table(IndexTable array[], IndexTable init_array[], int size);

/* winapi */
pred	P2_winLoadLibrary(Frame *Env);
pred	P3_winGetProcAddress(Frame *Env);
pred	P2_winAllocApiArg(Frame *Env);
pred	P1_winFreeApiArg(Frame *Env);
pred	P3_winStoreApiArgQWORD(Frame *Env);
pred	P3_winLoadApiArgQWORD(Frame *Env);
pred	P3_winStoreApiArgDWORD(Frame *Env);
pred	P3_winLoadApiArgDWORD(Frame *Env);
pred	P3_winStoreApiArgWORD(Frame *Env);
pred	P3_winLoadApiArgWORD(Frame *Env);
pred	P3_winStoreApiArgBYTE(Frame *Env);
pred	P3_winLoadApiArgBYTE(Frame *Env);
pred	P3_winStoreApiArgFLOAT(Frame *Env);
pred	P3_winLoadApiArgFLOAT(Frame *Env);
pred	P7_winCallApi(Frame *Env);
pred	P1_winWindowProc(Frame *Env);
pred	P1_winDialogProc(Frame *Env);
pred	P1_winCallbackProc2Args(Frame *Env);
pred	P1_winCallbackProc3Args(Frame *Env);
pred	P1_winCallbackProc4Args(Frame *Env);
pred	P1_winCallbackProc5Args(Frame *Env);
pred	P1_winAbortProc(Frame *Env);
pred	P1_winDdeCallback(Frame *Env);
pred	P1_winEditWordBreakProc(Frame *Env);
pred	P1_winFileIOCompletionRoutine(Frame *Env);
pred	P1_winOutputProc(Frame *Env);
pred	P1_winSendAsyncProc(Frame *Env);
pred	P1_winTimerProc(Frame *Env);
pred	P1_winVtblMemberProc(Frame *Env);
pred	P6_winReturnProc(Frame *Env);
pred	P2_winGetWinMainArgs(Frame *Env);
int	B2_winLoadLibrary(Frame *Env, TERM *arg1, TERM *arg2);
int	B3_winGetProcAddress(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B2_winAllocApiArg(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_winFreeApiArg(Frame *Env, TERM *arg1);
int	B3_winStoreApiArgQWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winLoadApiArgQWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winStoreApiArgDWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winLoadApiArgDWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winStoreApiArgWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winLoadApiArgWORD(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winStoreApiArgBYTE(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winLoadApiArgBYTE(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winStoreApiArgFLOAT(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B3_winLoadApiArgFLOAT(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3);
int	B7_winCallApi(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6, TERM *arg7);
int	B1_winWindowProc(Frame *Env, TERM *arg1);
int	B1_winDialogProc(Frame *Env, TERM *arg1);
int	B1_winCallbackProc2Args(Frame *Env, TERM *arg1);
int	B1_winCallbackProc3Args(Frame *Env, TERM *arg1);
int	B1_winCallbackProc4Args(Frame *Env, TERM *arg1);
int	B1_winCallbackProc5Args(Frame *Env, TERM *arg1);
int	B1_winAbortProc(Frame *Env, TERM *arg1);
int	B1_winDdeCallback(Frame *Env, TERM *arg1);
int	B1_winEditWordBreakProc(Frame *Env, TERM *arg1);
int	B1_winFileIOCompletionRoutine(Frame *Env, TERM *arg1);
int	B1_winOutputProc(Frame *Env, TERM *arg1);
int	B1_winSendAsyncProc(Frame *Env, TERM *arg1);
int	B1_winTimerProc(Frame *Env, TERM *arg1);
int	B1_winVtblMemberProc(Frame *Env, TERM *arg1);
int	B6_winReturnProc(Frame *Env, TERM *arg1, TERM *arg2, TERM *arg3, TERM *arg4, TERM *arg5, TERM *arg6);
int	B2_winGetWinMainArgs(Frame *Env, TERM *arg1, TERM *arg2);

/* write */
pred	P1_write(Frame *Env);
pred	P1_writeq(Frame *Env);
pred	P2_display(Frame *Env);
pred	P1_display(Frame *Env);
pred	P2_set_write_depth(Frame *Env);
pred	P2_set_write_list_length(Frame *Env);
int	B2_set_write_depth(Frame *Env, TERM *arg1, TERM *arg2);
int	B2_set_write_list_length(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_write(Frame *Env, TERM *arg1);
int	B1_writeq(Frame *Env, TERM *arg1);
int	B2_display(Frame *Env, TERM *arg1, TERM *arg2);
int	B1_display(Frame *Env, TERM *arg1);

/* compiled predicates from oleauto.pl */
pred	P3_automation(Frame *Env);
pred	P0_ole_initialize(Frame *Env);
pred	P0_ole_uninitialize(Frame *Env);
pred	P2_ole_create_object(Frame *Env);
pred	P1_ole_release_object(Frame *Env);
pred	P5_ole_call_method(Frame *Env);
pred	P5_ole_get_property(Frame *Env);
pred	P4_ole_put_property(Frame *Env);

/* clp_unit */
pred    P1_unfreeze(Frame *Env);
pred	P2_freeze(Frame *Env);
pred	P2_frozen(Frame *Env);
pred	P2_get_clp_area(Frame *Env);
pred	P2_put_clp_area(Frame *Env);
pred	P2_rm_clp_area(Frame *Env);
pred	P3_rm_area(Frame *Env);
int 	B3_rm_area(Frame *Env,TERM *arg1,TERM *arg2,TERM *arg3); 
// pred	P3_outof(Frame *Env);      
pred	P2_clp_is_member(Frame *Env);
pred	P2_system_get_min_max_int(Frame *Env);
pred	P2_system_get_tag(Frame *Env);
pred	P3_clp_intersection(Frame *Env);
int     B1_unfreeze(Frame *Env,TERM *arg1);
int	B2_freeze(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_frozen(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_get_clp_area(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_put_clp_area(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_rm_clp_area(Frame *Env,TERM *arg1,TERM *arg2);
int	B3_outof(Frame *Env,TERM *arg1,TERM *arg2,TERM *arg3);
int	B3_clp_intersection(Frame *Env,TERM *arg1,TERM *arg2,TERM *arg3);
int	B2_clp_is_member(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_system_get_min_max_int(Frame *Env,TERM *arg1,TERM *arg2);
int	B2_system_get_tag(Frame *Env,TERM *arg1,TERM *arg2);

/* dlib */
extern int  B1_dlib_require(Frame* Env, TERM* arg1);
extern pred P1_dlib_require(Frame *Env);
extern int  B2_dlib_require(Frame* Env, TERM* arg1, TERM* arg2);
extern pred P2_dlib_require(Frame *Env);
extern int  B1_dlib_get_error_str(Frame* Env, TERM* arg1);
extern pred P1_dlib_get_error_str(Frame *Env);
extern int  B1_dlib_get_load_map(Frame* Env, TERM* arg1);
extern pred P1_dlib_get_load_map(Frame *Env);
extern int  B1_dlib_get_search_path(Frame* Env, TERM* arg1);
extern pred P1_dlib_get_search_path(Frame *Env);
extern int  B1_dlib_set_search_path(Frame* Env, TERM* arg1);
extern pred P1_dlib_set_search_path(Frame *Env);
extern int  B1_dlib_search_path_push(Frame* Env, TERM* arg1);
extern pred P1_dlib_search_path_push(Frame *Env);
extern int  B0_dlib_search_path_pop(Frame* Env);
extern pred P0_dlib_search_path_pop(Frame *Env);
extern int  dlib_free(void);


#ifdef __cplusplus
}
#endif

#endif	/* end of azprolog.h */

