:-dlib_require(clp).

go :-
    write('% Five suspects including the criminal gave the following testimony.'),nl,
    write('% A [The criminal is D]'),nl,
    write('% B [I am innocent]'),nl,
    write('% C [E is not a criminal]'),nl,
    write('% D [A is a liar]'),nl,
    write('% E [B is honest]'),nl,
    write('%  The crime was carried out alone'),nl,
    write('%  It is unknown who it is, but there are two liars in them'),nl,
    write('%  Show Who is liar or honest,and look for the criminal '),nl,nl,

    Who_is_liar=[A,B,C,D,E],
    Who_is_liar in [liar,honest],
    Who_is_criminal=[AA,BB,CC,DD,EE],
    Who_is_criminal in [criminal,innocent],

    who_say(A,DD == criminal),
    who_say(B,BB == innocent),
    who_say(C,EE\== criminal),
    who_say(D, A == liar),
    who_say(E, B == honest),

    labeling_with_count(Who_is_liar,liar,2),
    labeling_with_count(Who_is_criminal,criminal,1),
       write(['A':[A,AA],'B':[B,BB],'C':[C,CC],'D':[D,DD],'E':[E,EE]]),nl,
    fail.

who_say(Who,Say) :-
    arg(1,Say,One),
    freeze(Who,(Who==honest->freeze(One,Say);freeze(One,\+Say))).

labeling_with_count([],_,0).
labeling_with_count([A|L],C,N):- 
    N>=0, indomain(A), (A==C ->M is N-1;M=N), labeling_with_count(L,C,M).

