#include <syslog.h>
#include <azprolog.h>

/* 

// prioritys
#define LOG_EMERG       0       /+ system is unusable +/
#define LOG_ALERT       1       /+ action must be taken immediately +/
#define LOG_CRIT        2       /+ critical conditions +/
#define LOG_ERR         3       /+ error conditions +/
#define LOG_WARNING     4       /+ warning conditions +/
#define LOG_NOTICE      5       /+ normal but significant condition +/
#define LOG_INFO        6       /+ informational +/
#define LOG_DEBUG       7       /+ debug-level messages +/

// option flag
#define LOG_PID         0x01    /+ log the pid with each message +/
#define LOG_CONS        0x02    /+ log on the console if errors in sending +/
#define LOG_ODELAY      0x04    /+ delay open until first syslog() (default) +/
#define LOG_NDELAY      0x08    /+ don't delay open +/
#define LOG_NOWAIT      0x10    /+ don't wait for console forks: DEPRECATED +/
#define LOG_PERROR      0x20    /+ log to stderr as well +/

// facility codes
#define LOG_KERN        (0<<3)  /+ kernel messages +/
#define LOG_USER        (1<<3)  /+ random user-level messages +/
#define LOG_MAIL        (2<<3)  /+ mail system +/
#define LOG_DAEMON      (3<<3)  /+ system daemons +/
#define LOG_AUTH        (4<<3)  /+ security/authorization messages +/
#define LOG_SYSLOG      (5<<3)  /+ messages generated internally by syslogd +/
#define LOG_LPR         (6<<3)  /+ line printer subsystem +/
#define LOG_NEWS        (7<<3)  /+ network news subsystem +/
#define LOG_UUCP        (8<<3)  /+ UUCP subsystem +/
#define LOG_CRON        (9<<3)  /+ clock daemon +/
#define LOG_AUTHPRIV    (10<<3) /+ security/authorization messages (private) +/
#define LOG_FTP         (11<<3) /+ ftp daemon +/
        /+ other codes through 15 reserved for system use +/
#define LOG_LOCAL0      (16<<3) /+ reserved for local use +/
#define LOG_LOCAL1      (17<<3) /+ reserved for local use +/
  :
 
 ?- openlog(newsyslog,1,16<<3), % StartUp Once
     syslog(5,my_log_wrie),     % 3(ERR),4(WARRNING),5(NOTICE),6(INFO),7(DEBUG)
    closelog.                   % Before Terminate Once

*/

/* openlog(char *ident,int logoption,int facility) */


extern BASEINT Numeric_s_num_eval_int(TERM *arg); /* source/numeric.c */

static	char ident[1024];

pred P3_openlog(Env)
Frame *Env;
{
	Atom2Asciz(GetAtom(next_var_cell-3),ident);
	openlog(ident,(int)Numeric_s_num_eval_int(next_var_cell-2),(int)Numeric_s_num_eval_int(next_var_cell-1) );
	YIELD(DET_SUCC);
}

/* syslog(int priority,char *message) */

pred P2_syslog(Env)
Frame *Env;
{
	char message[1024];

	Atom2Asciz(GetAtom(next_var_cell-1),message);
	syslog((int )Numeric_s_num_eval_int(next_var_cell-2), "%s", message);
	YIELD(DET_SUCC);
}

pred P0_closelog(Env)
Frame *Env;
{
	closelog();
	YIELD(DET_SUCC);
}

extern int initiate_az_syslog(void)
{
	put_bltn("openlog", 3,P3_openlog);
	put_bltn("syslog",  2,P2_syslog);
	put_bltn("closelog",0,P0_closelog);

  return 1;
}
