#ifndef WS_CLIENT_H
#define WS_CLIENT_H

#include "util.h"

extern void ws_set_log_level(int level_masks);
extern int ws_set_client_certificate_file_path(char* path);
extern int ws_set_client_private_key_file_path(char* path);
extern int ws_create_context(int sub_protocol_num,
                             const char sub_protocols[][WS_SUB_PROTOCOL_NAME_MAX_SIZE],
                             int default_protocol_index,
                             struct libwebsocket_context** r_context);
extern int ws_delete_context(struct libwebsocket_context* context);
extern PER_SESSION_DATA* ws_connect(int timeout, struct libwebsocket_context* context,
                                    const char* sub_protocol_name,
                                    const char*address, int port,
                                    int use_ssl, const char* path, const char* host,
                                    const char* origin, int ietf_version);
extern int ws_close(PER_SESSION_DATA* psd);
extern int ws_is_close(PER_SESSION_DATA* psd, int timeout);
extern int ws_read(int timeout, PER_SESSION_DATA* ps, char* buf, int buf_size);
extern int ws_write_text(PER_SESSION_DATA* ps, char* s, int len);
extern int ws_write_binary(PER_SESSION_DATA* ps, unsigned char* s, int len);
extern int ws_write_pong(PER_SESSION_DATA* ps, char* s, int len);

extern int ws_read_ready(int timeout, PER_SESSION_DATA* ps, void** pp);
extern int ws_read_finish(PER_SESSION_DATA* ps);
extern const char* ws_session_protocol(PER_SESSION_DATA* ps);

#endif /* WS_CLIENT_H */

