%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% AZ-Prolog.Ver 7 Benchmark Test Program %%
%%   2011.10.1    Tell.Inaba(SOFNEC)      %%
%%   2016.1.15    float write format      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% << How To Invoke Benchmark Test Program >>
%
%    ~AZ-Prolog.700/bench>benchmark
%    ~AZ-Prolog.700/bench>benchmark -p SWI-Prolog.rslt SICStus-Prolog.rslt ( File must exist)
%   I read a menu, and input according to it

% << How To ReMake Benchmark.exe by AZ-Prolog Compiler >>
%
% 1) DownLoad "The benchmark sources" from SICStus-Prolog Site To ~AZ-Prolog.700/bench/source
%    URL is "http://www.sics.se/isl/sicstuswww/site/performance.html"
% 2) Compile this program.     MS-C++ (Windows) or GCC (Linux) Must be installed
%    ~AZ-Prolog.700/bench>azpc -p az_main.pl /e benchmark /i /dcurses

%%%%%%%%%%%%%%%%%%%
%%% Main Module %%%
%%%%%%%%%%%%%%%%%%%

:- publicall.

az_class_define(
	[ 'AZ8-C.rslt', c,                % AZ-Prolog.v7 C-CodeResultFile      And ClassName
	  'AZ8-B.rslt', byte,             % AZ-Prolog.v7 Byte-codeResultFile   And ClassName
	  'AZ8-I.rslt', interpreter ] ).  % AZ-Prolog.v7 interpreterResultFile And ClassName

top_level:-
	s_version(Ver,OS,_,Bit),Ver1 is Ver//100,V2 is Ver mod 100,
	(V2<10->term_atom(V2,V2A),atom_append('0',V2A,Ver2A);term_atom(V2,Ver2A)),
	term_atom(Ver1,Ver1A), 
	atom_concats('AZ-Prolog V',[Ver1A,'.',Ver2A,' ',OS,' ',Bit],AZProlog),
	fileerrors(_,fail),
%	errormode(_,0),
	s_verbos(_,on),
	prompt(P,'Enter No.>'),
	az_class_define(CBI),
	repeat,
		nl,
		write_linenl(['      << ',AZProlog,' BenchMark Test Menu >>',                 nl,nl,
					  ' 1) Run  All BenchMark Program (if Added,Parameter File Load)',nl,
					  ' 2) Save AZ-Prolog-Benchmark-Result to Current Directory',     nl,
					  ' 3) Load All Result-File From Current Directory',              nl,
					  ' 4) Table-Style Result Display',                               nl,
					  ' 5) Graph-Style Result Display',                               nl,
					  ' 6) Break to Interpreter (Type "?-unbreak." To Return Here)',  nl,
					  ' 7) Exit ']),
		ttyget(No),nl,
		invoke_menu([No],P,CBI), 
	!,
	write('May AZ-Prolog Be With You !!'),nl.

invoke_menu("1",P, [_,C,_,B,_,I]):- !,do_test([C,B,I]),              fail.
invoke_menu("2",P, CBI          ):- !,save_result(CBI),              fail.
invoke_menu("3",P, _            ):- !,read_all_result,               fail.
invoke_menu("4",P, [_,C,_,B,_,I]):- !,write_result([C,B,I]),         fail.
invoke_menu("5",P, CBI          ):- !,write_result2(CBI),            fail.
invoke_menu("6",P, _            ):- !,prompt(N,P),break,prompt(_,N), fail.
invoke_menu("7",P, _            ):- !,prompt(_,P).
invoke_menu(X,P,Y):- 
	member([X,I],[["R","1"],["r","1"],["S","2"],["s","2"],["L","3"],["l","3"],
		          ["T","4"],["t","4"],["G","5"],["g","5"],["B","6"],["b","6"],["E","7"],["e","7"] ]),
	!,invoke_menu(I,P,Y).

%%%% <No.1> %%%%%
do_test([C,B,I]):-
	get_parameter(Files),
	read_result_file(Files),
	see('harness.pl'),tell('source/harness.pl'),copy0,told,seen,
	write('   ******  Running Benchmark Programs :: AZ-Prolog ******'),   nl,nl,
	write('---Module Name(Iterate)----   C-Code     ByteCode   Interpreter'),nl,
	write('-----------------------------+----------+----------+-----------'),nl,
	test_module(Module,Space,Iterate),
		write_line([Module,'(',Iterate,') :',Space]),
			(do_testc(C, Module,Iterate,TimeC),tab_write_fail(TimeC);true),
			(do_testc(B, Module,Iterate,TimeC),tab_write_fail(TimeC);true),
			(do_testi(I, Module,Iterate,TimeC),tab_write_fail(TimeC);true),
		nl,
	fail.

do_test([C,B,I]):- 
	\+ conc(I,_,_,_),
	!,
	write_linenl([nl,' To measure interpreter, you must download&unzip benchmark programs',nl,
					 '                       into "./source" from SICStus-Prolog''s site.',nl,
					 ' >> http://www.sics.se/isl/sicstuswww/site/performance.html',      nl]).
do_test(_).

%%%% InterPreter Code Call
do_testi(Class,Module,Iterate,Time2):-
	s_new,
	file_load(Module),
	!,
	bench(Iterate,Time),
	my_verify(Module,Result),
	save_to_heap(Class,Module,Time,Result,Time2).
do_testi(Class,Module,Iterate,' Program Not Exist!' ).

%%%% Bytecode,C-Code Call
do_testc(Class,Module,Iterate,Time2):-
		atom_concats(Class,['_',Module,'_bench'],NewFunc),
		Method=..[NewFunc,Iterate,Time,Result],
		once(errorset(Method,succ)),
		!,
		save_to_heap(Class,Module,Time,Result,Time2).
do_testc(_,_,_,          '          ').

%% To Free Stack %%%
tab_write_fail(X):- tab(1),write(X),fail.

%% Save result 
save_to_heap(Class,Module,Time,Result,Time2):-
		s_mode(_,on), 
			assert(conc(Class,Module,Time,[Result])), %% Save To Heap
		s_mode(_,off),
		time_format(Time,5," "," Sec",Time2).
		
%%%%%
atom_concats(A,[],A):-!.
atom_concats(A,[B|C],D):- atom_append(A,B,AB),atom_concats(AB,C,D).

once(X):- X,!.

%% Test ModuleName & Iteration %%

test_module(boyer,'                ',100).
test_module(browse,'               ',100).
test_module(chat_parser,'          ',100).
test_module(crypt,'              ',10000).
test_module(deriv,'             ',100000).
test_module(dynamic_unit_clause,'',10000).
test_module(fast_mu,'            ',10000).
test_module(flatten,'           ',100000).
test_module(itak,'                 ',100).
test_module(meta_qsort,'          ',5000).
test_module(mu,'                 ',10000).
test_module(nreverse,'          ',100000).
test_module(nreverse_builtin,'  ',100000).
test_module(poly,'                ',1000).
test_module(primes,'             ',10000).
test_module(prover,'             ',10000).
test_module(qsort,'             ',100000).
test_module(queens,'             ',10000).
test_module(query,'             ',100000).
test_module(reducer,'              ',500).
test_module(sendmore,'             ',500).
test_module(simple_analyzer,'      ',500).
test_module(tak,'                 ',1000).
test_module(unify,'              ',20000).
test_module(zebra,'                ',500).

%%%% <No.2> %%%%%
save_result( [CF,C,BF,B,IF,I] ):-
	conc(C,_,_,_),!,
	file_out(CF,C),
	file_out(BF,B),
	file_out(IF,I).

file_out(File,ID):- 
	once(conc(ID,_,_,_)),
	write_line(['Saving ',ID,' Code To ',File,' ....']),nl,
	tell(File),
	conc(ID,Modle,Time,Result),
		displayq(conc(ID,Modle,Time,Result)),write('.'),nl,
	fail.
file_out(_,_):- 
	told.

%%%% <No.3> %%%%%
read_all_result:-
	(s_version(_,'LINUX',_,_) -> 
		s_child(bash,['-c','ls *.rslt'],_,Stream,_);
		s_child(cmd,['/c dir /B *.rslt'],_,Stream,_)
	),
		get0(Stream,Pre),e_register(0,_,Pre),
		get0_one(Stream,D),get_file_names(Stream,D,X-X,Files),
	seen(Stream),
	read_result_file(Files),
	write_linenl([Files,' Loaded']).

get_file_names(Stream,end,_,[]):- !.
get_file_names(Stream,31,X-[],[File|L]):- 
	!,name(File,X), get0_one(Stream,D),get_file_names(Stream,D,Y-Y,L).
get_file_names(Stream,D, X-[D|Y],Files):- 
	get0_one(Stream,N),get_file_names(Stream,N,X-Y,Files).

get0_one(S,Char):- get0(S,Next),!,e_register(0,Char,Next).
get0_one(S,end).

%%%%%%
read_result_file(Files):-
	s_mode(_,on), 
		abolish(param_conc,2),
		abolish(conc,4),
		init_file_read(Files,1), 
	s_mode(_,off).

%%%%%%
init_file_read([],_):-!.
init_file_read([File|Others],N):- 
	once(errorset(consult(File),_)),
	( name(File,[A,Z,S,H|_]),name('AZ7-',[A,Z,S,H]) -> NN is N
		; clause(conc,4,-1,conc(ID,_,_,_)),assertz(param_conc(ID,N)),NN is N+1 ),
	init_file_read(Others,NN).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Result Output To Console : Table Style %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% <No.4> %%%%%

write_result([C,B,I]):-
	once(conc(C,_,_,_)),
	get_other_prolog(Other),
	write_linenl(['-----------------------------------------------------------------------------',nl,
				  'RuntimeSeconds(Rate) Verify "T":Base "t":SameToBase "F":NotSame "_":NoResult',nl,nl,
				  '                           <========  AZ-Prolog  ==========>  ',nl,
				  'ModuleName  Verify Iterate C-Compile  Byte-Compile  Interpreter   [',resize(Other,10),']']),
	write_line,
	init_register(0,7),
	test_module(Module,_,Iterate),
		get_runtime(C,    Module,RC,CTime,CResult),  %float(RC) =/= 0.0,
		get_runtime(B,    Module,RB,BTime,BResult),  get_rate(RC,RB,CB),
		get_runtime(I,    Module,RI,ITime,IResult),  get_rate(RC,RI,CI),
		get_runtime(Other,Module,RS,STime,SResult),  get_rate(RC,RS,CS),
		add_register([RC,RB,RI,RS,RB/RC,RI/RC,RS/RC],0),
		verify_check(CResult,[BResult,IResult,SResult],Results),
		write_linenl([resize(Module,11),' ',[Results],tab(7-integer(log10(Iterate))),Iterate,CTime,' (1) ',BTime,CB,' ',ITime,CI,' ',STime,CS]),
	fail.

write_result(_):-
	e_register(0,E,E),  % E is Program Count
	E /== 0,
	get_register(" "," ",1,5,[C,B, I, S ],0),
	get_register("(",")",*,4,[  BC,IC,SC],4),
	write_line,
	write_linenl(['      Total(Average)      ',C,'(1) ',B,BC,' ',I,IC,' ',S,SC]),
	nl.

%%%%
get_other_prolog(''):- clause(param_conc,2,0),!.
get_other_prolog(Other):- clause(param_conc,2,1),!,param_conc(Other,_).

get_other_prolog(Other):-
	repeat,
		write('    >>>> Enter PrologSystem No. To Compare'),nl,
		write_others(1),
	write('      '),ttyget(No),
	name(Num,[No]),
	check_num(Num,Num2),
	param_conc(Other,Num2),!.

write_others(N):- param_conc(X,N),!,check_num(N,No),write_linenl(['      (',No,') ',X]),NN is N+1,write_others(NN).
write_others(_).

check_num(N,N):- integer(N),N<10,!.
check_num(N,M):- integer(N), M1 is "a"+N-10,name(M,[M1]).
check_num(N,M):- atom(N),name(N,[M1]),M is M1-"a"+10.

%%%%%% Verify 2 Term Completely Equal %%%%%%%%

verify_check(no_result,[B|List],Ans):-!,verify_check(B,[B|List],'_',Ans).
verify_check(C,List,Ans):- verify_check(C,List,'T',Ans).

verify_check(_,[],L,L):-!.
verify_check(no_result,[B|List],L,Ans):-
	!,atom_append(L,'_',LX),verify_check(B,List,LX,Ans).

verify_check(X,[A|L],B,Ans):- same_term(X,A),!,atom_append(B,'t',BN),verify_check(X,L,BN,Ans).
verify_check(X,[A|L],B,Ans):- var(A),!,atom_append(B,'f',BN),verify_check(X,L,BN,Ans).
verify_check(X,[no_result|L],B,Ans):-!,atom_append(B,'_',BN),verify_check(X,L,BN,Ans).
verify_check(X,[_|L],B,Ans):-!,atom_append(B,'F',BN),verify_check(X,L,BN,Ans).

same_term(X,Y):- nonvar(X),nonvar(Y),!,\+(\+(as_same(1,_,X,Y))).

as_same(N,NN,X,Y):- var(X),var(Y),!,X='$_var'(N),X=Y,NN is N+1.
as_same(N,N, X,Y):- atomic(X),atomic(Y),!,X=Y.
as_same(N,N, X,Y):- float(X),float(Y),!,X=Y.
as_same(N,NN,X,Y):- list(X),list(Y),!,X=[X1|X2],Y=[Y1|Y2],as_same(N,N1,X1,Y1),as_same(N1,NN,X2,Y2).
as_same(N,NN,X,Y):- nonvar(X),nonvar(Y),!,X=..[F|X2],Y=..[F|Y2],as_same(N,NN,X2,Y2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Initialize Average Counter %%
init_register(N,N):-!.
init_register(N,M):- e_register(N,_,0),f_register(N,_,0.0),NN is N+1,init_register(NN,M).

%%% Add Average Counter
add_register([],_):-!.
add_register([A|L],N):-
	errormode(Er,0),(errorset(AA is A,succ)->true;AA=0),!,errormode(_,Er), 
	(AA /== 0.0,AA /== 0->e_register(N,ER,ER+1),f_register(N,B,B+AA);true),
	NN is N+1,add_register(L,NN).

%%% Get Counter Value and calculation
get_register(H,T,D,Lng,[],_):-!.
get_register(H,T,D,Lng,[Disp|L],N):-
	get_register_sub(D,N,DD,RateS),
	f_register(N,S,S),SS is RateS*(S/DD),
	time_format(SS,Lng,H,T,Disp),
	NN is N+1,
	get_register(H,T,D,Lng,L,NN).

get_register_sub(1,_,1,1):-!.
get_register_sub(_,N,D,1000):- e_register(N,D,D),D>0,!.
get_register_sub(_,N,1,1000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

get_runtime(Type,Module,Time,Time2,Result):-
	conc(Type,Module,Time,Result),Result \= [fail],
	!,time_format(Time,5," ","",Time2).
get_runtime(_,_,0,'      ',no_result).
	
time_format(Time0,Lng,H,T,Time2):-
	Time is Time0/1000.0,
	term_atom(Time,Time1),
	name(Time1,List),
	time_format2(List,Lng,T,List2),
	append(H,List2,List3),!,
	name(Time2,List3).     

time_format2(_,0,T,T):-!.
time_format2([A|L],N,T,[A|R]):-NN is N-1,time_format2(L,NN,T,R).
/* 2016.1.15 add Next 1 Line */
time_format2([],N,T,[48|R]):-NN is N-1,time_format2([],NN,T,R).

%%%%
get_rate(_,0,'       '):-!.
get_rate(0,_,'       '):-!.
get_rate(A,B, CC     ):- C is (B/A)*1000,time_format(C,4," (",")",CC).

%%%%%%%%
write_linenl(C):-write_line(C),!,nl.

write_line([]):-!.
write_line([nl|L]):- !,nl,write_line(L).
write_line([tab(X)|L]):- !,tab(X),write_line(L).
write_line([resize(X,N)|L]):- !,resize_atom(X,N,XX),write_line([XX|L]).
write_line([X|L]):- write(X),write_line(L).

write_line :- write('-----------+-CBIO-+-------+----------+-------------+-------------+------------'),nl.
write_line2:- write('-----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+--'),nl.

resize_atom(A,N,Aw):-
	name(A,AList),
	resize_atom2(AList,N,ARist),
	name(Aw, ARist).

resize_atom2(_,0,[]):-!.
resize_atom2([],N,[32|L]):-!,NN is N-1,resize_atom2([],NN,L).
resize_atom2([A|R],N,[A|L]):-NN is N-1,resize_atom2(R,NN,L).

%%%% <No.5> %%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%  Result Output To Console : Dot Style %%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

write_result2([CF,C,BF,B,IF,I]):-
	conc(C,_,_,_),!,
	BaseDiv is 72,
	write_linenl([resize(IF,5),':AZ-Prolog.v7 Interpreter,',resize(BF,5),':ByteCode,',resize(CF,5),':FullCompileCode']),
	all_other_module(Others,1),   % Parameter Direction File
	test_module(Module,_,Iterate),
		get_runtimes([C,B,I|Others],Module,[CR|OtherRuntime]),
		get_max_min(CR,OtherRuntime,Max,'<'),
		Max /== 0,
		Base is Max/BaseDiv,
		get_my_dot_size(Base,[CR|OtherRuntime],[CS,BS,IS|DotSize]),
		get_my_dot([CR|OtherRuntime],[CD,BD,ID|DotType]),
		write(Module/Iterate),
		write('             <---- Fast (Fastest is "oooooo")'),nl,
		write_line2,
		write_dot_style([IF,BF,CF],[IS,BS,CS],[ID,BD,CD]),
		write_line2,
		write_dot_style(Others,DotSize,DotType),
		write_line2,
		nl,
	fail.


%%% Fastest System's Dot = "o" Other="*"
get_my_dot([A|Time],Dot):-
	get_max_min(A,Time,B,'>'),
	get_my_dot3(B,[A|Time],Dot).

%%% Extract Max or Min Data
get_max_min(A,[],A,Func):-!.
get_max_min(A,[B|L],Ans,Func):- B /== 0,Term=..[Func,A,B],call(Term),!,get_max_min(B,L,Ans,Func).
get_max_min(A,[_|L],Ans,Func):- get_max_min(A,L,Ans,Func).

get_my_dot3(_,[],[]):-!.
get_my_dot3(A,[A|L],["o"|R]):- !,get_my_dot3(A,L,R).
get_my_dot3(A,[_|L],["*"|R]):- get_my_dot3(A,L,R).

%%%
all_other_module([A|L],N):- param_conc(A,N),!,NN is N+1,all_other_module(L,NN).
all_other_module([],_).

%%% 
get_runtimes([],  _,[]):- !.
get_runtimes([A|L],  Module,[Time|Times]):- 
	( conc(A,Module,Time,Result),Result \= [fail] -> true; Time=0 ),get_runtimes(L,Module,Times).

%%%
get_my_dot_size(Base,[],[]):-!.
get_my_dot_size(Base,[X|OtherRuntime],[XC|ELSE]):-
		XC is integer(X/Base),
		get_my_dot_size(Base,OtherRuntime,ELSE).

%%%
write_dot_style([],[],[]):-!.
write_dot_style([A|Others],[B|DotSize],[C|DotType]):-
	resize_atom(A,5,Aw),
	write(Aw),
	write('|'),puts(C,B),	
	write_dot_style(Others,DotSize,DotType).

puts(_,0):-!,nl.
puts(D,N):- put(D),NN is N-1,puts(D,NN).

%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% For InterPreter %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%

file_load(X):- atom_append('source/',X,Y),atom_append(Y,'.pl',Z),consult(Z).

%%%%% Verify Set %%%%%
my_verify(browse,Y):-
    Y= [[star(SA),B,star(SB),B,a,star(SA),a,star(SB),star(SA)],
        [star(SA),star(SB),star(SB),star(SA),[star(SA)],[star(SB)]],
        [_,_,star(_),[b,a],star(_),_,_] ],
    init(100,10,4, [[a,a,a,b,b,b,b,a,a,a,a,a,b,b,a,a,a], [a,a,b,b,b,b,a,a,[a,a],[b,b]], 
                    [a,a,a,b,[b,a],b,a,b,a] ], Symbols),
    randomize(Symbols,RSymbols,21),!,investigate(RSymbols,Y).

my_verify(chat_parser, Y):- string(X),determinate_say(X,Y),!.
my_verify(fast_mu,     Y):- data(G), length(G, GL1), GL is GL1 - 1, derive([m,i], G, 1, GL, Y, 0),!.
my_verify(flatten, [X,Y]):- eliminate_disjunctions([(a(A,_,C):-(b(A);c(C)))],X,Y,[]),inst_vars((X,Y)),!.
my_verify(meta_qsort,Ans):- interpret(qsort([6,3,7,5,2,1,4,9,0,8],Ans,[]) ),!.
my_verify(prover,      C):- problem(_, P, C),implies(P, C),!.

my_verify(sendmore,[S,E,N,D,M,O,R,E,M,O,N,E,Y]):- 
	digit(D), digit(E), D=/=E,
	sumdigit(0, D, E, Y, C1),
	digit(N), N=/=Y, N=/=E, N=/=D,
	digit(R), R=/=N, R=/=Y, R=/=E, R=/=D,
	sumdigit(C1,N, R, E, C2),
	digit(O), O=/=R, O=/=N, O=/=Y, O=/=E, O=/=D,
	sumdigit(C2,E, O, N, C3),
	leftdigit(S), S=/=O, S=/=R, S=/=N, S=/=Y, S=/=E, S=/=D,
	leftdigit(M), M=/=S, M=/=O, M=/=R, M=/=N, M=/=Y, M=/=E, M=/=D,
	sumdigit(C3,S, M, O, M),!.
	
my_verify(zebra,Y):- data(Y),benchmark(Y,_),!.
my_verify(_,Z):-  once(data(D)),once(benchmark(D,Z)),nonvar(Z),!.
my_verify(_,fail).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%           END OF Main-Module               %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% C Source Module Division %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%% 1 %%%%%%%%%%%%%
:- module c_boyer.

:- public c_boyer_bench/3.
c_boyer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/boyer.pl'].

%%%%%%%%%%% 2 %%%%%%%%%%%%%
:- module c_browse.

:- public c_browse_bench/3.
c_browse_bench(X,Y,Z):- 
	bench(X,Y),
    Z= [[star(SA),B,star(SB),B,a,star(SA),a,star(SB),star(SA)],
        [star(SA),star(SB),star(SB),star(SA),[star(SA)],[star(SB)]],
        [_,_,star(_),[b,a],star(_),_,_] ],
    init(100,10,4,
         [[a,a,a,b,b,b,b,a,a,a,a,a,b,b,a,a,a],
          [a,a,b,b,b,b,a,a,[a,a],[b,b]],
          [a,a,a,b,[b,a],b,a,b,a] ], Symbols),
    randomize(Symbols,RSymbols,21),!,
    investigate(RSymbols,Z).

:- ['source/browse.pl'].

%%%%%%%%%%%% 3 %%%%%%%%%%%%
:- module c_chat_parser.

:- public c_chat_parser_bench/3.
c_chat_parser_bench(X,Y,Z):- bench(X,Y),string(S),determinate_say(S,Z),!.

:- ['source/chat_parser.pl'].

%%%%%%%%%%%% 4 %%%%%%%%%%%%
:- module c_crypt.

:- public c_crypt_bench/3.
c_crypt_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/crypt.pl'].

%%%%%%%%%%%% 5 %%%%%%%%%%%%
:- module c_deriv.

:- public c_deriv_bench/3.
c_deriv_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/deriv.pl'].

%%%%%%%%%%%% 6 %%%%%%%%%%%%
:- module c_dynamic_unit_clause.

:- public c_dynamic_unit_clause_bench/3.
c_dynamic_unit_clause_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/dynamic_unit_clause.pl'].

%%%%%%%%%%%% 7 %%%%%%%%%%%%
:- module c_fast_mu.

:- public c_fast_mu_bench/3.
c_fast_mu_bench(X,Y,Z):- 
	bench(X,Y), data(G),length(G,GL1),GL is GL1-1,derive([m,i],G,1,GL,Z,0).

:- ['source/fast_mu.pl'].

%%%%%%%%%%% 8 %%%%%%%%%%%%%
:- module c_flatten.

:- public c_flatten_bench/3.
c_flatten_bench(X,Y,[Xv,Yv]):- 
	bench(X,Y),
	eliminate_disjunctions([(a(A,_,C):-(b(A);c(C)))],Xv,Yv,[]),
    inst_vars((Xv,Yv)).

:- ['source/flatten.pl'].

%%%%%%%%%%% 9 %%%%%%%%%%%%%
:- module c_itak.

:- public c_itak_bench/3.
c_itak_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['c_itak.pl'].

%%%%%%%%%%%% 10 %%%%%%%%%%%%
:- module c_meta_qsort.

:- public c_meta_qsort_bench/3.
c_meta_qsort_bench(X,Y,Z):- bench(X,Y),interpret(qsort([6,3,7,5,2,1,4,9,0,8],Z,[]) ).

:- ['source/meta_qsort.pl'].

%%%%%%%%%%% 11 %%%%%%%%%%%%%
:- module c_mu.

:- public c_mu_bench/3.
c_mu_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/mu.pl'].

%%%%%%%%%%%% 12 %%%%%%%%%%%%
:- module c_nreverse.

:- public c_nreverse_bench/3.
c_nreverse_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/nreverse.pl'].

%%%%%%%%%%%%% 13 %%%%%%%%%%%
:- module c_nreverse_builtin.

:- public c_nreverse_builtin_bench/3.
c_nreverse_builtin_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/nreverse_builtin.pl'].

%%%%%%%%%%%%% 14 %%%%%%%%%%%
:- module c_poly.

:- public c_poly_bench/3.
c_poly_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/poly.pl'].

%%%%%%%%%%%%% 15 %%%%%%%%%%%
:- module c_primes.

:- public c_primes_bench/3.
c_primes_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/primes.pl'].

%%%%%%%%%%% 16 %%%%%%%%%%%%%
:- module c_prover.

:- public c_prover_bench/3.
c_prover_bench(X,Y,Z):- bench(X,Y),problem(_, P, Z),implies(P, Z),!.

:- ['source/prover.pl'].

%%%%%%%%%%% 17 %%%%%%%%%%%%%
:- module c_qsort.

:- public c_qsort_bench/3.
c_qsort_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/qsort.pl'].

%%%%%%%%%%%% 18 %%%%%%%%%%%%
:- module c_queens.

:- public c_queens_bench/3.
c_queens_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/queens.pl'].

%%%%%%%%%%%% 19 %%%%%%%%%%%%
:- module c_query.

:- public c_query_bench/3.
c_query_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/query.pl'].

%%%%%%%%%%% 20 %%%%%%%%%%%%%
:- module c_reducer.

:- public c_reducer_bench/3.
c_reducer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/reducer.pl'].

%%%%%%%%%%% 21 %%%%%%%%%%%%%
:- module c_sendmore.

:- public c_sendmore_bench/3.
c_sendmore_bench(ParamX,ParamY,[S,E,N,D,M,O,R,E,M,O,N,E,Y]):- 
	bench(ParamX,ParamY),
		digit(D), digit(E), D=/=E,
		sumdigit(0, D, E, Y, C1),
		digit(N), N=/=Y, N=/=E, N=/=D,
		digit(R), R=/=N, R=/=Y, R=/=E, R=/=D,
		sumdigit(C1,N, R, E, C2),
		digit(O), O=/=R, O=/=N, O=/=Y, O=/=E, O=/=D,
		sumdigit(C2,E, O, N, C3),
		leftdigit(S), S=/=O, S=/=R, S=/=N, S=/=Y, S=/=E, S=/=D,
		leftdigit(M), M=/=S, M=/=O, M=/=R, M=/=N, M=/=Y, M=/=E, M=/=D,
		sumdigit(C3,S, M, O, M).

:- ['source/sendmore.pl'].

%%%%%%%%%% 22 %%%%%%%%%%%%%%
:- module c_simple_analyzer.

:- public c_simple_analyzer_bench/3.
c_simple_analyzer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/simple_analyzer.pl'].

%%%%%%%%%% 23 %%%%%%%%%%%%%%
:- module c_tak.

:- public c_tak_bench/3.
c_tak_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/tak.pl'].

%%%%%%%%%% 24 %%%%%%%%%%%%%%
:- module c_unify.

:- public c_unify_bench/3.
c_unify_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/unify.pl'].

%%%%%%%%%%% 25 %%%%%%%%%%%%%
:- module c_zebra.

:- public c_zebra_bench/3.
c_zebra_bench(X,Y,D):- bench(X,Y),data(D),benchmark(D,_).

:- ['source/zebra.pl'].

%%%% END OF C-Source Compile Division %%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ByteCode Module Division %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%% 1 %%%%%%%%%%%%%

:- module byte_boyer/bytecode.

:- public byte_boyer_bench/3.
byte_boyer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/boyer.pl'].

%%%%%%%%%%% 2 %%%%%%%%%%%%%
:- module byte_browse/bytecode.

:- public byte_browse_bench/3.
byte_browse_bench(X,Y,Z):- 
	bench(X,Y),
    Z= [[star(SA),B,star(SB),B,a,star(SA),a,star(SB),star(SA)],
        [star(SA),star(SB),star(SB),star(SA),[star(SA)],[star(SB)]],
        [_,_,star(_),[b,a],star(_),_,_] ],
    init(100,10,4,
         [[a,a,a,b,b,b,b,a,a,a,a,a,b,b,a,a,a],
          [a,a,b,b,b,b,a,a,[a,a],[b,b]],
          [a,a,a,b,[b,a],b,a,b,a] ], Symbols),
    randomize(Symbols,RSymbols,21),!,
    investigate(RSymbols,Z).

:- ['source/browse.pl'].

%%%%%%%%%%%% 3 %%%%%%%%%%%%
:- module byte_chat_parser/bytecode.

:- public byte_chat_parser_bench/3.
byte_chat_parser_bench(X,Y,Z):- bench(X,Y),string(S),determinate_say(S,Z),!.

:- ['source/chat_parser.pl'].

%%%%%%%%%%%% 4 %%%%%%%%%%%%
:- module byte_crypt/bytecode.

:- public byte_crypt_bench/3.
byte_crypt_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/crypt.pl'].

%%%%%%%%%%%% 5 %%%%%%%%%%%%
:- module byte_deriv/bytecode.

:- public byte_deriv_bench/3.
byte_deriv_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/deriv.pl'].

%%%%%%%%%%%% 6 %%%%%%%%%%%%
:- module byte_dynamic_unit_clause/bytecode.

:- public byte_dynamic_unit_clause_bench/3.
byte_dynamic_unit_clause_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/dynamic_unit_clause.pl'].

%%%%%%%%%%%% 7 %%%%%%%%%%%%
:- module byte_fast_mu/bytecode.

:- public byte_fast_mu_bench/3.
byte_fast_mu_bench(X,Y,Z):- 
	bench(X,Y), data(G),length(G,GL1),GL is GL1-1,derive([m,i],G,1,GL,Z,0).

:- ['source/fast_mu.pl'].

%%%%%%%%%%% 8 %%%%%%%%%%%%%
:- module byte_flatten/bytecode.

:- public byte_flatten_bench/3.
byte_flatten_bench(X,Y,[Xv,Yv]):- 
	bench(X,Y),
	eliminate_disjunctions([(a(A,_,C):-(b(A);c(C)))],Xv,Yv,[]),
    inst_vars((Xv,Yv)).

:- ['source/flatten.pl'].

%%%%%%%%%%% 9 %%%%%%%%%%%%%
:- module byte_itak/bytecode.

:- public byte_itak_bench/3.
byte_itak_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['byte_itak.pl'].

%%%%%%%%%%%% 10 %%%%%%%%%%%%
:- module byte_meta_qsort/bytecode.

:- public byte_meta_qsort_bench/3.
byte_meta_qsort_bench(X,Y,Z):- bench(X,Y),interpret(qsort([6,3,7,5,2,1,4,9,0,8],Z,[]) ).

:- ['source/meta_qsort.pl'].

%%%%%%%%%%% 11 %%%%%%%%%%%%%
:- module byte_mu/bytecode.

:- public byte_mu_bench/3.
byte_mu_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/mu.pl'].

%%%%%%%%%%%% 12 %%%%%%%%%%%%
:- module byte_nreverse/bytecode.

:- public byte_nreverse_bench/3.
byte_nreverse_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/nreverse.pl'].

%%%%%%%%%%%%% 13 %%%%%%%%%%%
:- module byte_nreverse_builtin/bytecode.

:- public byte_nreverse_builtin_bench/3.
byte_nreverse_builtin_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/nreverse_builtin.pl'].

%%%%%%%%%%%%% 14 %%%%%%%%%%%
:- module byte_poly/bytecode.

:- public byte_poly_bench/3.
byte_poly_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/poly.pl'].

%%%%%%%%%%%%% 15 %%%%%%%%%%%
:- module byte_primes/bytecode.

:- public byte_primes_bench/3.
byte_primes_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/primes.pl'].

%%%%%%%%%%% 16 %%%%%%%%%%%%%
:- module byte_prover/bytecode.

:- public byte_prover_bench/3.
byte_prover_bench(X,Y,Z):- bench(X,Y),problem(_, P, Z),implies(P, Z),!.

:- ['source/prover.pl'].

%%%%%%%%%%% 17 %%%%%%%%%%%%%
:- module byte_qsort/bytecode.

:- public byte_qsort_bench/3.
byte_qsort_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/qsort.pl'].

%%%%%%%%%%%% 18 %%%%%%%%%%%%
:- module byte_queens/bytecode.

:- public byte_queens_bench/3.
byte_queens_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/queens.pl'].

%%%%%%%%%%%% 19 %%%%%%%%%%%%
:- module byte_query/bytecode.

:- public byte_query_bench/3.
byte_query_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/query.pl'].

%%%%%%%%%%% 20 %%%%%%%%%%%%%
:- module byte_reducer/bytecode.

:- public byte_reducer_bench/3.
byte_reducer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/reducer.pl'].

%%%%%%%%%%% 21 %%%%%%%%%%%%%
:- module byte_sendmore/bytecode.

:- public byte_sendmore_bench/3.
byte_sendmore_bench(ParamX,ParamY,[S,E,N,D,M,O,R,E,M,O,N,E,Y]):- 
	bench(ParamX,ParamY),
		digit(D), digit(E), D=/=E,
		sumdigit(0, D, E, Y, C1),
		digit(N), N=/=Y, N=/=E, N=/=D,
		digit(R), R=/=N, R=/=Y, R=/=E, R=/=D,
		sumdigit(C1,N, R, E, C2),
		digit(O), O=/=R, O=/=N, O=/=Y, O=/=E, O=/=D,
		sumdigit(C2,E, O, N, C3),
		leftdigit(S), S=/=O, S=/=R, S=/=N, S=/=Y, S=/=E, S=/=D,
		leftdigit(M), M=/=S, M=/=O, M=/=R, M=/=N, M=/=Y, M=/=E, M=/=D,
		sumdigit(C3,S, M, O, M).

:- ['source/sendmore.pl'].

%%%%%%%%%% 22 %%%%%%%%%%%%%%
:- module byte_simple_analyzer/bytecode.

:- public byte_simple_analyzer_bench/3.
byte_simple_analyzer_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/simple_analyzer.pl'].

%%%%%%%%%% 23 %%%%%%%%%%%%%%
:- module byte_tak/bytecode.

:- public byte_tak_bench/3.
byte_tak_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/tak.pl'].

%%%%%%%%%% 24 %%%%%%%%%%%%%%
:- module byte_unify/bytecode.

:- public byte_unify_bench/3.
byte_unify_bench(X,Y,Z):- bench(X,Y),data(D),benchmark(D,Z).

:- ['source/unify.pl'].

%%%%%%%%%%% 25 %%%%%%%%%%%%%
:- module byte_zebra/bytecode.

:- public byte_zebra_bench/3.
byte_zebra_bench(X,Y,D):- bench(X,Y),data(D),benchmark(D,_).

:- ['source/zebra.pl'].

%%%%%%%%%% EOF %%%%%%%%%%%%

