%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSL認証局へ証明書データ(root.pem,key.pem)で認証を行い
%%  データの送受信を行う
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  client_connect,ssl_cert_load_data,ssl_cert_send,
%%  ssl_cert_receive,socket_close,ssl_cert_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket).
:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  証明書データを宣言する                       %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	CERT_DATA ="-----BEGIN CERTIFICATE-----
MIICqDCCAhGgAwIBAgIJAKMK3Rs2DqDdMA0GCSqGSIb3DQEBBQUAMG0xCzAJBgNV
BAYTAkpQMRYwFAYDVQQIDA1UZXN0IFByb3ZpbmNlMQ4wDAYDVQQHDAVUb2t5bzEM
MAoGA1UECgwDU0JNMREwDwYDVQQLDAhTU0wgVGVzdDEVMBMGA1UEAwwMc2JtLnRl
c3QuY29tMB4XDTEzMDkyMDA0MjAwM1oXDTEzMTAyMDA0MjAwM1owbTELMAkGA1UE
BhMCSlAxFjAUBgNVBAgMDVRlc3QgUHJvdmluY2UxDjAMBgNVBAcMBVRva3lvMQww
CgYDVQQKDANTQk0xETAPBgNVBAsMCFNTTCBUZXN0MRUwEwYDVQQDDAxzYm0udGVz
dC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAJdkgzUkstrw5tuLNF6y
hJPLtudUKGXfPYjMd2pzT6wkKprdEGQnaeQUDSdRKBrBNwC61OW19OChnvZ8pq8b
TU9EYXs551+XLUHpsiFFxTgZWEqV0NJB27GHRrHnfEOUnPZZKNYwiDsiVvRbKVnL
7O8sUY0Z9ckEstucXo1M/GbBAgMBAAGjUDBOMB0GA1UdDgQWBBSfQISWTYo4Tf9w
jY5Qz4+kTmQD7zAfBgNVHSMEGDAWgBSfQISWTYo4Tf9wjY5Qz4+kTmQD7zAMBgNV
HRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAJcQh7bwuIYD6gUFG+dnPpx1EIkc
N76pA02539lJvz9J151UPONSBp7831sP9SC6oP12u8b+4to6QMJlsA2XjPbIejQe
zEjpn6V4IXLk2C/Q8qcwyo+NOUX523hi9bbwFu8+ayF79L5rPuusx9Wb0KirMs0T
x32TKj2mV3E+I44Z
-----END CERTIFICATE-----",
	KEY_DATA = "-----BEGIN ENCRYPTED PRIVATE KEY-----
MIICxjBABgkqhkiG9w0BBQ0wMzAbBgkqhkiG9w0BBQwwDgQIcZMg3NK2VVECAggA
MBQGCCqGSIb3DQMHBAhdEtWHf3lSEQSCAoAFNRYx/LOK1DAaomRDGqMTqHiPehPo
0qOClRWQC/JGQegXQmP5RRl/EdGyIpyj7FcviLplIt+Kd0+BR4DUljVlFsYAiGpk
jVsY7VqycTp7XBWTMgPxZmRVt3+Ait/xHgacItYXw4NXpn48osx5Fh/An8n0NJ6F
qPmkY4V2RRTzOAqPvtLdZhHYzDMsGKXersqAL9GjD9zr3My5kIbMh91QSUueuflz
CVt+F6V4UWpkpT+vsMZnaymhnWKT91uKWIvVeEnpn/vC86vfJQegaC1d/34nhKoq
v7HI15uV0wx7N/mYU54sqd2ERO9iLEsj/lZX1cgSofPvk5fQH/uUjrdk14uhmMsB
BXQyJYuW5C/oPQMNQQPrRsuPIOA3uwJ8GUeo5u01Wt/ypz6XDFGYvXa4H7XwEJj7
EGbDLG2CmVXJ/ZBsRs3JH+m8Aj4YeCMWW8QAlQFhG9iij9S7+WUKi/Qzr5299tNw
Q9/emiegtFhZwQAOpTd5e0b+oL1N3QWjMPtvXChXQSQW8jzWgK7H4jzFB2WkF6+L
CQa4kdtnjylnsV4mywzcikw75Iv0epigPus3Y3AzhTjPhOx7CIuD5TP5oB/UtXVo
82b1MGEqkDZvgKM67vQFKYXPbbVZu/qIfbx7eFcZ5SolI5zStbZY5llsQ4mlK4kA
W/9Q0pw1jr/G3dYtrjRModdjhzY3TBkpYZnaccY1lGVn1VipT+AJXaDUtF81cxt/
EyfeBk5dpA+5w7wHDjIQlsDX0iUz1zNr3BDWL408jtT9pnwnGCB5N5JykLQVeS13
QzXlXoXDt5pQV0Rl9sLoQ0VREUAi/qdSKOuo1Q9H0EOkwQ1NpXkDRQRf
-----END ENCRYPTED PRIVATE KEY-----",

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  LFコードの変換する                           %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	lf_all_chg(CERT_DATA,CERT_DATA2),
	lf_all_chg(KEY_DATA,KEY_DATA2),
	name(NCERT,CERT_DATA2),
	name(NKEY,KEY_DATA2),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーに接続する                       %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	client_connect('127.0.0.1','3000',S),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバー証明書データで認証要求を行う         %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_cert_load_data(S,NCERT,NKEY,SN),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーへデータを送信する               %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	name(C,[10]),
	Data1='Cert Test2 Message',
	atom_concat(Data1,C,Data),
	ssl_cert_send(SN,Data),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーからデータを受信する             %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	get_all(SN,"",LAns),
	name(Ans,LAns),
	write(Ans),nl,

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーの切断                           %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	socket_close(S),
	ssl_cert_close(SN).


%%%%% データ受信処理 %%%%%
get_all(SN,Bef,Ans):-
    ssl_cert_receive(SN,Out,Sz),name(Out,OutL),length(OutL,N),N>0,!,
    append(Bef,OutL,NextBef),
    get_all(SN,NextBef,Ans).
get_all(SN,A,A).


%%%%% LFコードの変換処理 %%%%%
lf_all_chg([],[]):-!.
lf_all_chg([C|X],[S|Y]):-
    (C == 31->S = 10;S = C),
    lf_all_chg(X,Y).

