/*
	エラーメッセージ　メンテナンス　ユーティリティー

	| ?-['error.pl'].
	yes
	| ?-error.
	yes


　エラーメッセージ　メンテナンス　ユーティリティーは、エラーメッセージデータベースファイルＥＲＲＭＳＧ．ＰＤＦを作成します。
　ｅｒｒ／２を変更することによりメッセージを変える事が出来ます。
　ＥＲＲＭＳＧ．ＰＤＦは、カレントディレクトリに作成されますので、旧ＥＲＲＭＳＧ．ＰＤＦが入っているディレクトリにコピーしてください。
*/



err(  1,'Syntax error').
err(  2,'Can''t see the file').
err(  3,'Can''t tell the file').
err(  4,'End of file encountered').
err(  5,'Illegal file name').
err(  6,'Too many variables').
err(  7,'Too complex term').
err(  8,'Builtin or C pred exist').

err(  9,'Illegal argument supplied').
err( 10,'Illegal Goal').
err( 11,'Illegal clause').
err( 12,'Illegal define tag').
err( 13,'Illegal throw tag').
err( 14,'Illegal catch tag').
err( 15,'Unknown predicate call').

err( 16,'Heap area exausted').
err( 17,'Trail stack overflow').
err( 18,'Global stack overflow').
err( 19,'Local stack overflow').
err( 20,'Malloc failed').

err( 21,'No more break').
err( 22,'Evaluation error: zero_divisor'). /* modified by N.T. Hashimoto for ISO, 2011/11/23 */
err( 23,'Too complex arithmetic').
err( 24,'Evaluation error: Arithmetic Overflow').	/* modified by N.T. Hashimoto for ISO, 2011/11/23 */
err( 25,'Evaluation error: Arithmetic Underflow').	/* modified by N.T. Hashimoto for ISO, 2011/11/23 */

err( 26,'Illegal Arithmetic expression').
err( 27,'Illegal character code').
err( 28,'Edit buffer no space').
err( 29,'Kill buffer no space').
err( 30,'Out of buffer').

err( 31,'^G error').
err( 32,'Search string is too long').

/*
	numbers of 33, 34 are assigned for GUI related messages
*/

/*
	added by N.T. Hashimoto for ISO Compliance, 2011/11/23, update 2011/11/28
*/

/*
	Instantiation error
	type_error(atom, atomic, byte, callable, character, evaluable,
			in_byte, in_character, integer, list, number, 
			predicate_indicator, variable)
	evaluation_error(float_overflow, int_overflow, undefined, underflow, zero_divisor)
	syntax_error

	acos, asin: Evaluation error: defined from -1.0 to 1.0
	sqrt: Evaluaton error: must be >= 0.0
	log, log10: Evaluation error: must be > 0.0
	(//), <<, >>, \/, /\,\: Type error: integer expected
	^,**: Evaluation error: integer_overflow, float_overflow
	other: Evaluatoin error: undefined
	
*/

err( 35,'Instantiation error'). /* X is cos(X) */
err( 36,'Type error: integer expected'). /* X is 1.0 << 2.0 */
err( 37,'Type error: float expected').
err( 38,'Type error: number expected').       /* modified 2011/11/28 */
err( 39,'Type error: not evaluable').
err( 40,'Evaluation error: float_overflow'). /* X is big number ** big number */
err( 41,'Evaluation error: int_overflow').
err( 42,'Evaluation error: undefined').      /* X is log(0.0) */
err( 43,'Evaluation error underflow').
err( 44,'Evaluation error: random seed not initialized').
err( 45,'Type error: predicate_indicator expected'). /* 2011/11/28 */
err( 46,'Type error: character expected').           /* 2011/11/28 */
err( 47,'Type error: atom expected').                /* 2011/11/28 */
err( 48,'Type error: list expected').                /* 2011/11/28 */
err( 49,'Type error: variable expected').            /* 2011/11/28 */
err( 50,'Type error: byte code expected').           /* 2011/11/28 */
err( 51,'Atom area exausted').						/* 2013/04/18 */

err( 52,'Feature name already exists').				/* 2015/09/10 */
err( 53,'Feature name has to be an atom').			/* 2015/09/10 */
err( 54,'Feature and non-feature mixed').			/* 2015/09/10 */


err(200,'user errors limit').
err(  X,'UNKNOWN ERROR').


error :-
%	d_create('errmsg.pdf',[error,80]),
	d_create('errmsg.db',[error,80]),
	e_register(0,_,1),
	repeat,
	e_register(0,ENO,ENO+1),
	get_err(ENO,D),
%	d_writeq('errmsg.pdf',ENO,[[error,D]]),ENO == 200,
	d_writeq('errmsg.db',ENO,[[error,D]]),ENO == 200,
	!,
%	d_close('errmsg.pdf').
	d_close('errmsg.db').

get_err(ENO,D) :- err(ENO,D),!.

