#!/usr/local/bin/prologcgi

:-s_charset(_,utf8).
:-kanji_mode(_,off).
:- dlib_require(oniguruma).

top_call:-
    get_params(A,B,C),
    html_call([
    "Content-Type: text/html; charset=utf-8

     <html lang='ja'><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'> 
     <title>鬼車</title></head> 
     <body><center> 
     <H1> 正規表現パッケージ「鬼車」＋ＡＺ　デモンストレーション　</H1> 

     <a href='puttxt.exe?oniguruma.cgi' target='source'>このページのソース表示</a><br> 
     <INPUT TYPE='button' VALUE='RETURN' onClick='history.back()'><br><br>
     <h3><table border='1' cellpadding='3' cellspacing='0' width='80%'> 
     <form action='oniguruma.cgi' method='POST'>
        <tr><td><a href='../RE_ja.html' target='source'>正規表現　</a></td> 
                    <td><input type='text' size='100' name = 'pattern' value='",A,"'></td></tr> 
        <tr><td>検索開始位置</td><td><input type='text' size='3'   name = 'start'   value='",B,"'></td></tr> 
        <tr><td>検索対象    </td><td><textarea cols='70' rows='10' name = 'target' >",
            call(puts(C)), "</textarea></td></tr> 
        <tr><td><input type='submit' name='sub' value='【正規表現による検索】'></td></tr> 
     </form> <tr><td>",
        call(go(A,B,C)),
    "</td></tr> </table></center></body></html>" ]).

%%%%%%%%%%%%%%%%
get_params(A,B,C):-get_paramA(A),get_paramB(B),get_paramC(C).

get_paramA(A):-get_param(pattern,A),!.
get_paramA('((P|p)rolog)(......)').

get_paramB(B):-get_param(start,B),integer(B),!.
get_paramB(0).

get_paramC(C):-get_param(target,CC),!,(atom(CC)->name(CC,C);CC=C).
get_paramC(X):-search_data(X).

%%%%%%%%%%%%%%%%
go(Pattern,Start,TargetString):-
    onig_pattern_compile(Pattern,REGEX),!,
        onig_make_target_string(TargetString,Target),
            onig_search_success(REGEX,Target, Start, _,MSTART,MEND,CAPTURES,NEXT),
            write_result(MSTART,MEND,CAPTURES,NEXT),
        onig_free_target_string(Target),
    onig_pattern_free(REGEX).
    
go(Pattern,_,_):-
    write('正規表現のパターン指定が不正です</td><td>'),
    onig_pattern_error_info(Pattern,ERR),write(ERR).

%%%%%%%%%%%%%

write_result(MSTART,MEND,CAPTURES,NEXT):-
    write_listnl(['マッチした位置: ',MSTART,'<br>']),
    write_listnl(['マッチ終了位置: ',MEND,'<br>']),
    write_listnl(['次以降検索位置: ',NEXT,'<br>']),
    write('</td><td>'),
    write('[取得文字列]<br>'),write_captures(CAPTURES).

write_captures([]):-!.
write_captures([A|L]):-puts(A),write('<br>'),write_captures(L).

puts([]):- !.
puts([C|T]):- !,put(C),puts(T).
puts(A):- write(A).

%%%% 検索対象初期値
search_data(
"（1）Prolog言語の知識
AZ-Prologのシンタックスは「DEC-10　Prolog」に準拠していますので、その知識を前提とします。
このマニュアルの「Chapter4・Prolog言語」でもProlog言語について解説をしていますが、Prolog言語を全くご存じ無い方には少々説明が不足かも知れません。そこで、Prolog言語についての入門書を読みながらこのインタープリタを使っていかれることをお奨めします。
Prolog言語の解説は次項の「Prolog言語に関する参考文献」で紹介します。
（2）OSの知識
各OSの立ち上げプロセスを始め、エディタの概念などは最低限知っている必要があります。また、AZ-Prologではコマンドライン・ユーティリティーを実行出来る「system」述語一時的にOSのコマンド・プロンプトレベルに抜けられる「sh」述語とがあります。
これを使用する場合は、用途に応じた知識が必要です。").
