%% HowTo Invoke
%% SWI-Prolog:  >Start SWI-Prolog  ?-chdir('C://AZ-Prolog.700/bench').  ?-[iso_main].
%% AZ-Prolog:   >prolog_c -s iso_main.pl

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Define Benchmark Prolog-system's ResultFileName,Identifier %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
my_define( 'AZ7b-Prolog.rslt','AZ7b-Prolog').   % Bytecode Compile on Interpreter
%my_define( 'SICStus-Prolog.rslt','SICStus-Prolog').

%%% Result Output To File %%%
verify(Name,Time):- 
	my_define(File,ID),
	my_verify(Name,Result),!,
%	append(File),
	open(File,append,S),
%		displayq(conc(ID,Name,Time,[Result])),write('.'),nl,
		write_canonical(S,conc(ID,Name,Time,[Result])),write(S,.),nl(S),
	close(S),
	write(Name=Time/ms),nl.

%%%%% Verify Set %%%%%
my_verify(browse,Y):-
    Y= [[star(SA),B,star(SB),B,a,star(SA),a,star(SB),star(SA)],
        [star(SA),star(SB),star(SB),star(SA),[star(SA)],[star(SB)]],
        [_,_,star(_),[b,a],star(_),_,_] ],
    init(100,10,4,
         [[a,a,a,b,b,b,b,a,a,a,a,a,b,b,a,a,a],
          [a,a,b,b,b,b,a,a,[a,a],[b,b]],
          [a,a,a,b,[b,a],b,a,b,a] ], Symbols),
    randomize(Symbols,RSymbols,21),!,
    investigate(RSymbols,Y).

my_verify(chat_parser,Y):-
	string(X),determinate_say(X,Y),!.

my_verify(fast_mu,Y):- 
	data(G), length(G, GL1), GL is GL1 - 1,derive([m,i], G, 1, GL, Y, 0),!.

my_verify(flatten, [X,Y]) :- 
	eliminate_disjunctions([(a(A,_,C):-(b(A);c(C)))],X,Y,[]),inst_vars((X,Y)),!.

my_verify(meta_qsort,Ans):-  interpret(qsort([6,3,7,5,2,1,4,9,0,8],Ans,[]) ),!.

my_verify(prover,C):-  problem(_, P, C),implies(P, C),!.

my_verify(sendmore,[S,E,N,D,M,O,R,E,M,O,N,E,Y]):- 
	digit(D), digit(E), D=\=E,
	sumdigit(0, D, E, Y, C1),
	digit(N), N=\=Y, N=\=E, N=\=D,
	digit(R), R=\=N, R=\=Y, R=\=E, R=\=D,
	sumdigit(C1,N, R, E, C2),
	digit(O), O=\=R, O=\=N, O=\=Y, O=\=E, O=\=D,
	sumdigit(C2,E, O, N, C3),
	leftdigit(S), S=\=O, S=\=R, S=\=N, S=\=Y, S=\=E, S=\=D,
	leftdigit(M), M=\=S, M=\=O, M=\=R, M=\=N, M=\=Y, M=\=E, M=\=D,
	sumdigit(C3,S, M, O, M),!.
	
my_verify(zebra,Y):- data(Y),benchmark(Y,_),!.
my_verify(_,Y):-  data(X),benchmark(X,Y),nonvar(Y),!.
my_verify(_,fail).

%%% Initialize Result File %%%
(:- my_define(File,_),tell(File),told).

compile(X):- write(X),nl,compile(X).

%%%% Benchmark Main %%%%%

(:-set_prolog_flag(redefine_warnings,off)).
(:-compile('source/boyer.pl'),              bench(   100,Time),verify(boyer,Time)).
(:-compile('source/browse.pl'),             bench(   100,Time),verify(browse,Time)).
(:-compile('source/chat_parser.pl'),        bench(   100,Time),verify(chat_parser,Time)).
(:-compile('source/crypt.pl'),              bench( 10000,Time),verify(crypt,Time)).
(:-compile('source/deriv.pl'),              bench(100000,Time),verify(deriv,Time)).
(:-compile('source/dynamic_unit_clause.pl'),bench( 10000,Time),verify(dynamic_unit_clause,Time)).
(:-compile('source/fast_mu.pl'),            bench( 10000,Time),verify(fast_mu,Time)).
(:-compile('source/flatten.pl'),            bench(100000,Time),verify(flatten,Time)).
(:-compile('source/itak.pl'),               bench(   100,Time),verify(itak,Time)).
(:-compile('source/meta_qsort.pl'),         bench(  5000,Time),verify(meta_qsort,Time)).
(:-compile('source/mu.pl'),                 bench( 10000,Time),verify(mu,Time)).
(:-compile('source/nreverse.pl'),           bench(100000,Time),verify(nreverse,Time)).
(:-compile('source/nreverse_builtin.pl'),   bench(100000,Time),verify(nreverse_builtin,Time)).
(:-compile('source/poly.pl'),               bench(  1000,Time),verify(poly,Time)).
(:-compile('source/primes.pl'),             bench( 10000,Time),verify(primes,Time)).
(:-compile('source/prover.pl'),             bench( 10000,Time),verify(prover,Time)).
(:-compile('source/qsort.pl'),              bench(100000,Time),verify(qsort,Time)).
(:-compile('source/queens.pl'),             bench( 10000,Time),verify(queens,Time)).
(:-compile('source/query.pl'),              bench(100000,Time),verify(query,Time)).
(:-compile('source/reducer.pl'),            bench(   500,Time),verify(reducer,Time)).
(:-compile('source/sendmore.pl'),           bench(   500,Time),verify(sendmore,Time)).
(:-compile('source/simple_analyzer.pl'),    bench(   500,Time),verify(simple_analyzer,Time)).
(:-compile('source/tak.pl'),                bench(  1000,Time),verify(tak,Time)).
(:-compile('source/unify.pl'),              bench( 20000,Time),verify(unify,Time)).
(:-compile('source/zebra.pl'),              bench(   500,Time),verify(zebra,Time)).
(:-halt).
