#!/usr/local/bin/prologcgi_l32


/* 64bit OS #! prologcgi_l32 / 32bit OS #! prologcgi_l */

:-s_charset(_,utf8).
:- kanji_mode(_,off).

:- b_load(sjis_utf8).   /* Place "sjis_utf8.b"  On CGI-BIN Directory */

top_call:-
  get_params(A),
  html_call([
	"Content-Type: text/html; charset=UTF-8",
	 call(nl),call(nl),
	"<html lang='ja'><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>
	 <title>Morphological analysis</title></head> 
	 <body><center> 
	 <H1>UTF-8 Input=>Sjis_Processing(By Mecab)=>Output</H1> 
	 <INPUT TYPE='button' VALUE='RETURN' onClick='history.back()'><br><br> ",
	 "<font size=8> 
	 <h3><table border='1' cellpadding='3' cellspacing='0' width='90%'> 
	 <tr> 
	 <form action='mecabtest.cgi' method='POST'>
		<td>
			<input type='text' size='100' name = 'mecab' value='",A,"'>
			<input type='submit' name='sub' value='Morphological analysis'>
		</td>
		</form>
	 </tr>
	 <tr><td> ",
		call(go(A)),
	"<br></td></tr></table></font></center></body></html>"]).

get_params(AL):-get_param(mecab,A),!,check_and_convert(A,AL).
get_params(Data):- sjis_to_utf8("なにか文字列をUTF-8で入力してください。",Data).

check_and_convert(Parameter,List):-
		(atom(Parameter) -> name(Parameter,ParameterList) ; ParameterList=Parameter),
		(sjis_to_utf8(ParameterList,List) -> true ;ParameterList=List).
		
go(Parameter):-
		write(uts8=Parameter),nl,write('<br>'),
		utf8_to_sjis(Parameter,S),
		write(sjis=S),nl,write('<br><br><br>'),
		mecab_new(M, []),
		mecab_sparse_tonode(M, S, 12, Out),
		mecab_destroy(M),
	!,
	write_nls(Out).
go(_).

write_nls([]):-!.
write_nls([X|L]):-check(X),write('<br>'),write_nls(L).

check(0.0):-!.
check([X|Y]):-!,write('['),writeq(X),check(X),check(Y),write(']').
check(''):-!.
check(X):- atom(X),!,name(X,XL),sjis_to_utf8(XL,Xout),puts(Xout).
check(_).

puts([]):-!.
puts([A|B]):-put(A),puts(B).
