/*
     SEND+MORE = MONEY

?- [-'sendmore.pl'].
?- sendmoreCLP(-Vars,-MilliSecond).     % CLP Version
?- sendmore(-Vars,-MilliSecond).        % Prolog Version

*/

:- dlib_require(clp).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Using CLP predicate

sendmoreCLP(Vars,Time):-
  statistics(runtime,[Begin,_]),
    Vars   = [S,E,N,D,M,O,R,Y],
    Vars in 0..9,
    alldifferent(Vars),
  S #\= 0,
  M #\= 0,
            S*1000+E*100+N*10+D
           +M*1000+O*100+R*10+E
 #= M*10000+O*1000+N*100+E*10+Y,
    labeling(Vars),
  statistics(runtime,[End,_]),
  Time is End-Begin.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Normal Prolog Code     Generate & Test

sendmore(Vars,Time):-
  statistics(runtime,[Begin,_]),
    Vars   = [S,E,N,D,M,O,R,Y],
    Domain = [0,1,2,3,4,5,6,7,8,9],
    alldifferent(Vars,Domain),
    S \= 0,
    M \= 0,
             S*1000+E*100+N*10+D
            +M*1000+O*100+R*10+E
 =:= M*10000+O*1000+N*100+E*10+Y,
 statistics(runtime,[End,_]),
 Time is End-Begin.

%%%%
alldifferent([],_).
alldifferent([X|L],Dom):- my_select(Dom,X,Other),alldifferent(L,Other).

my_select([A|L],A,L).
my_select([B|L],A,[B|R]):- my_select(L,A,R).

