<?php
require_once('dblib/mysDBLib.php');

class manDBClass {
	private $dbs;

	// ********************************************
	// **  データベース接続処理                  **
	// ********************************************
	public function db_connect() {
		$this->dbs = new mysDBClass();
		$this->dbs->db_init();
		$this->dbs->db_connect() or die("* Error: Can not connect database.\n");
	}

	// ********************************************
	// **  manualページのコンテンツ情報取得処理  **
	// ********************************************
	public function get_html_manpage_info($id = null, $file = null) {
		$data = "";

		if($id == null && $file == null) return $data;

		if($id != null) {
			$where = "id = $id";
		}
		else {
			$where = "file = 'manuals/$file'";
		}

		// HTMLコンテンツを取得する
		$arr = $this->dbs->db_select("desc_html", "page_funcdesc_data", $where);
		if(count($arr) > 0) {
			$html_data = $arr[0]['desc_html'];
		}

		// 述語名を取得する
		if($html_data != "") {
			// HTMLコンテンツ上の制御文字を変換する
			$html_data = str_replace("[%quot%]",  "&quot;",  $html_data);	// "
			$html_data = str_replace("[%amp%]" ,  "&amp;" ,  $html_data);	// &
			$html_data = str_replace("[%lt%]"  ,  "&lt;"  ,  $html_data);	// <
			$html_data = str_replace("[%gt%]"  ,  "&gt;"  ,  $html_data);	// >
			$html_data = str_replace("[%yen%]" ,  "&yen;" ,  $html_data);	// \
			$html_data = str_replace("[%brvbar%]","&brvbar;",$html_data);	// |

			$where = "used = 1";
			$arr = $this->dbs->db_select("id,name", "jyutsugo_data", $where);
			for($i = 0; count($arr) > $i; $i++ ) {
				if($arr[$i]['name'] == "1") continue;
				$href = "<a href=\"javascript:void(0)\" onclick=\"jyutsugo_window('".$arr[$i]['name']."',".$arr[$i]['id'].");\">".$arr[$i]['name']."</a>";
				$html_data = str_replace("<&tag>".$arr[$i]['name']."</&tag>", $href, $html_data);
				//$html_data = str_replace($arr[$i]['name'], $href, $html_data);
			}
			$html_data = str_replace("<&tag>",  "", $html_data);
			$html_data = str_replace("</&tag>", "", $html_data);
		}

		return $html_data;
	}

	// ********************************************
	// **  述語データの情報取得処理              **
	// ********************************************
	//public function get_jyutsugo_info() {
	//	$data = '';
	//	$arr = $this->dbs->db_select("*", "jyutsugo_data", null);
	//	if(count($arr) > 0) {
	//		for($i = 0;count($arr) > $i; $i++) {
	//			$data .= "var hash={}; ";
	//			$data .= "hash[\"id\"]="."\"".$arr[$i]['id']."\"; ";
	//			$data .= "hash[\"name\"]="."\"".$arr[$i]['name']."\"; ";
	//			$data .= "hash[\"common\"]="."\"".$arr[$i]['common']."\"; ";
	//			$data .= "hash[\"format\"]="."\"".$arr[$i]['format']."\"; ";
	//			$data .= "hash[\"argument\"]="."\"".$arr[$i]['argument']."\"; ";
	//			$data .= "hash[\"text\"]="."\"".$arr[$i]['desc_text']."\"; ";
	//			$data .= "hash[\"reference\"]="."\"".$arr[$i]['reference']."\"; ";
	//			$data .= "hash[\"sample\"]="."\"".$arr[$i]['sample']."\"; ";
	//			$data .= "hash[\"genre\"]="."\"".$arr[$i]['genre_id']."\"; ";
	//			if($arr[$i]['genre'] == 0) $flag = 'false';
	//			else $flag = 'true';
	//			$data .= "hash[\"used\"]="."\"".$flag."\"; ";
	//			$data .= "hash[\"incident\"]="."\"".$arr[$i]['incident']."\"; ";
	//			$data .= "azlist.push(hash);\n";
	//		}
	//	}

	//	return $data;
	//}

	// ********************************************
	// **  データベースクローズ                  **
	// ********************************************
	public function db_close() {
		$this->dbs->db_close();
	}
}
?>
