#ifndef WS_UTIL_H
#define WS_UTIL_H

#include <time.h>
#include <sys/time.h>
#include <openssl/ssl.h>
#include <libwebsockets.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define WS_SUB_PROTOCOL_NAME_MAX_SIZE   256
#define MAX_MESSAGE_QUEUE 64

struct a_message {
	void *payload;
	size_t len;
};

typedef struct PER_SESSION_DATA_STRUCT {
  struct libwebsocket* wsi;
  struct libwebsocket_context* context;
  int opened;
  int ringbuffer_head;
  int ringbuffer_tail;
  struct a_message ringbuffer[MAX_MESSAGE_QUEUE];
} PER_SESSION_DATA;


extern void ws_time(struct timeval* tv);
extern int  ws_time_diff(struct timeval* start, struct timeval* end);
extern void ws_print_reason(enum libwebsocket_callback_reasons reason);
extern void ws_clear_ringbuffer(PER_SESSION_DATA* ps, int do_free);

#endif /* WS_UTIL_H */
