#!/usr/local/bin/prologcgi

:-s_charset(_,utf8).
:- kanji_mode(_,off).
:- dlib_require(mecab).

top_call:-
  get_params(A),
  html_call([
	"Content-Type: text/html; charset=utf-8",
	 call(nl),call(nl),
	"<html lang='ja'><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
	 <title>形態素解析</title></head> 
	 <body><center> 
	 <H1> Hello Prolog World!!　形態素解析Tool　Mecab＋AZ　</H1> 
	 <a href='puttxt.exe?mecabtest.cgi' target='source'>このページのソース表示</a><br>
	 <INPUT TYPE='button' VALUE='RETURN' onClick='history.back()'><br><br> ",
	 "<font size=8> 
	 <h3><table border='1' cellpadding='3' cellspacing='0' width='90%'> 
	 <tr> 
	 <form action='mecabtest.cgi' method='POST'>
		<td>
			<input type='text' size='100' name = 'mecab' value='",A,"'>
			<input type='submit' name='sub' value='形態素解析'>
		</td>
		</form>
	 </tr>
	 <tr><td> ",
		call(go(A)),
	"<br></td></tr></table></font></center></body></html>"]).

get_params(A):-get_param(mecab,A),!.
get_params('今日一日はとても良い天気でした').

go(A):-
	(atom(A) -> name(A,S);A=S),
		mecab_new(M, []),
		mecab_sparse_tonode(M, S, 12, Out),
		mecab_destroy(M),
	!,
	write_nls(Out).
go(_).

write_nls([]):-!.
write_nls([X|L]):-check(X,Y),write(Y),nl,write('<br>'),write_nls(L).

check(0.0,'0.0'):-!.
check([X|Y],[A|B]):-!,check(X,A),check(Y,B).
check(X,X).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  子プロセス方式のMecabアクセス
/*
my_mecab_new([In,Out,ID],Param):-  s_child(mecab,Param,In,Out,ID).
my_mecab_destroy([_,_,ID]) :- s_kill(ID,9).
my_mecab_sparse_tonode([I,O|_],X,_,K):-
	launch_put(I,X), 
	launch_get(O,'EOS',[32,9,44],K).   % StopAtom is 'EOS' Delemita is 32(Space),Tab(9),Comma(44)

%% Put
launch_put(I,[A|L]) :-put(I,A),launch_put(I,L).
launch_put(I,[]) :- !,nl(I).

%% Get 
launch_get(O,Stop,Delimita,L):- launch_get2(O,[Stop],Delimita,dummy,[_|L]).

launch_get2(O,Stop,_,  Stop ,[]   ):-!.
launch_get2(O,Stop,Del,X,    [X|L]):- get0(O,S),m_get(Del,O,S,Q-Q,Y),launch_get2(O,Stop,Del,Y,L).

m_get(_,  O,31,Q-[],   W):- !,m_to_atom(Q,W-[]).                                               % End Of Line
m_get(DEL,O,D, Q-[],   W):- member(D,DEL),!,m_to_atom(Q,W-L),get0(O,Y),m_get(DEL,O,Y,R-R,L).   % Delimita
m_get(DEL,O,X, Q-[X|R],W):- get0(O,Y),m_get(DEL,O,Y,Q-R,W).                                    % Word Proceeding

m_to_atom([],L-L):-!.
m_to_atom(X,[A|L]-L):-name(A,X).
*/
