:- dlib_require(clp).
go :-
   write('% 5 Person exist.'),nl,
   write('% Carol is 40 years old'),nl,
   write('% Luke  is 16 years old'),nl,
   write('% Sum of their age is 135'),nl,
   write('% Ascending order of their age is Luke,Tommy,Andrew,Jessica,Carol'),nl,
   write('% Luke is 5 years younger than one of them'),nl,nl,

   People = [Luke,Tommy,Andrew,Jessica,Carol],
   People in [0..135],
   Carol   #= 40,
   Luke    #= 16,
   135 #= Andrew+Carol+Jessica+Luke+Tommy,
   num_order(People,#<),
   freeze(Luke, some_one_is(Luke+5,People)),
   labeling(People),
   write([ 'Luke'    =Luke,
           'Tommy'   =Tommy,
           'Andrew'  =Andrew,
           'Jessica' =Jessica,
           'Carol'   =Carol ]),nl,
   fail.

some_one_is(Age,[A|L]) :- freeze(A,(A is Age;some_one_is(Age,L))).

num_order([A,B|L],Op):-!,Goal=..[Op,A,B],call(Goal),num_order([B|L],Op).
num_order(_,_).
