%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSL認証局へ証明書認証を行いデータの送受信を行う
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  client_connect,ssl_cert_load_cafile,ssl_cert_send,
%%  ssl_cert_receive,socket_close,ssl_cert_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket).
:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーに接続する                       %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	IP='127.0.0.1',
	CERT_FILE='server.pem',
	client_connect(IP,'3000',S),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバー証明書の認証要求を行う               %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_cert_load_cafile(S,CERT_FILE,S2),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーへデータを送信する               %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	name(C,[10]),
	Data1='Get Data Request',
	atom_concat(Data1,C,Data),
	ssl_cert_send(S2,Data),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーからデータを受信する             %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	get_all(S2,"",LAns),
	name(Ans,LAns),
	write(Ans),nl,

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーの切断                           %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	socket_close(S),
	ssl_cert_close(S2).

get_all(SN,Bef,Ans):-
	ssl_cert_receive(SN,Out,Sz),name(Out,OutL),length(OutL,N),N>0,!,
	append(Bef,OutL,NextBef),
	get_all(SN,NextBef,Ans).
get_all(SN,A,A).

