/*
 CU-Prolog builtin predicate for AZ-Prolog
   2015.10.27 T.Inaba (SOFNEC)
*/

:- fs_delimiter(_,/).

% ?- call_all(p([mary,meets,john])).
call_all(P):- e_register(0,_,1),P,e_register(0,N,N+1),write('No.'= N),nl,fail.

default(X,Y,Z):- \+(\+(X=Y)),X=Z.
project_cstr(_).
pcon.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tree(T):- tree(T,[]).

tree(t(t(S,N,_),T2,T3),TB):- !,tree_w(TB,S,N,B1,B2),tree(T2,B1),tree(T3,B2).
tree(t(S,N,_),         TB):-   tree_w(TB,S,N,_,_).

tree_w(TB,S,N,B1,B2):-
    tree_tb(TB,L,E,B1,B2),tree_w(L),nl,tree_w(L),tree_w([E,S,' --- ',N]),nl.

tree_tb([P],  [' |'],E,  [P,left],[P,right]):- !,tree_c(P,_,E).
tree_tb([P|V],[D|L], E,  [P|Q],[P|Z]):- !,tree_c(P,D,_),tree_tb(V,L,E,Q,Z).
tree_tb([],   [],   '',  [left],  [right]  ).

tree_c(left, ' |  ','--'):-!.
tree_c(right,'    ','__').

tree_w([]):-!.
tree_w([A|L]):-write(A),tree_w(L).
