:- kanji_mode(_, off).

t:-
  cabocha_new(CABO, ['azcabocha', '-n1']),
  write('cabocha_new done.'), nl,
  assert(work_cabocha(CABO)),
  test_repeat(10, CABO),
  cabocha_destroy(CABO),
  write('cabocha_destroy done.'), nl,
  cabocha_version(VERSION), write('Version: '), write(VERSION), nl,
  !.
t:-
  work_cabocha(CABO),
  cabocha_strerror(CABO, ERR),
  write(ERR), nl.

test_repeat(N, CABO):-
  repeat(I),
  ex(CABO),
  I1 is I + 1,
  write('--- REPEAT '), write(I1), write(' END. ---'), nl,
  I1 >= N.

ex(CABO):-
  exec(CABO, "灯りを付けましょぼんぼりに"),
  exec(CABO, "今日は楽しいひな祭り"),
  exec(CABO, "ローカルスタック上からグローバルスタックを指している値が更新されるが、bringArgs()の戻り値を、GCによる更新前のアドレスに代入している。"),
  exec_tree(CABO, "BIG_ENDIANという名前ではプラットフォーム上での定義と名前の衝突が起こりやすいので、AZ_BIG_ENDIANに変更した。"),
  exec_tree(CABO, "百二十三人が行方不明になった。"),
  exec_tree_token(CABO, "百二十三人が行方不明になった。", 1),
  exec_tree_token(CABO, "百二十三人が行方不明になった。", 9),
  exec_tree(CABO, "太郎と花子は2013年高野山大学を卒業した").


exec(CABO, STATEMENT):-
  cabocha_sparse_tostr(CABO, STATEMENT, RESULT),
  out_list(RESULT), nl.

exec_tree(CABO, STATEMENT):-
  cabocha_sparse_totree(CABO, STATEMENT, TREE),
  write('tree address: '), write(TREE), nl,
  cabocha_tree_size(TREE, SIZE),
  write('token num: '), write(SIZE), nl,
  cabocha_tree_get_chunk_list(TREE, CHUNK_LIST),
  write('chunk list: '), nl,
  out_chunks_list(CHUNK_LIST), nl.

exec_tree_token(CABO, STATEMENT, I):-
  cabocha_sparse_totree(CABO, STATEMENT, TREE),
  cabocha_tree_token(TREE, I, TOKEN),
  write('token at '), write(I), write(' : '), display(TOKEN), nl.


out_chunks_list([]):- !.
out_chunks_list([CHUNK|T]):-
  out_chunk(CHUNK),
  out_chunks_list(T).

out_chunk([LINK,HEAD_POS,FUNC_POS,TOKEN_SIZE,TOKEN_POS,SCORE,FS,ADDITIONAL_INFO|TOKENS]):-
  write('CHUNK:'), nl,
  write('  LINK:       '), display(LINK), nl,
  write('  HEAD_POS:   '), display(HEAD_POS), nl,
  write('  FUNC_POS:   '), display(FUNC_POS), nl,
  write('  TOKEN_SIZE: '), display(TOKEN_SIZE), nl,
  write('  TOKEN_POS:  '), display(TOKEN_POS), nl,
  write('  SCORE:      '), display(SCORE), nl,
  write('  FEATURE_LIST: '), display(FS), nl,
  write('  ADDITIONAL_INFO: '), display(ADDITIONAL_INFO), nl,
  write('  TOKENS:'), nl,
  out_tokens_list(TOKENS).

out_tokens_list([]):- !.
out_tokens_list([M|T]):-
  write('    '), display(M), nl,
  out_tokens_list(T).



out_list([]):- !.
out_list([C|T]):-
  put(C), out_list(T).


%:- t.
