%% For SWI-Prolog    %% Under 2 Line is Different from Original

:- redefine_system_predicate(plus(_,_,_)).
:- redefine_system_predicate(string(_)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A generic benchmark harness

runtime_entry(start) :-
	bench(1000).

bench(Count,Time) :-    %%  Original is  bench(Count) :- 
	cputime(T0),
	dodummy(Count),
	cputime(T1),
	dobench(Count),
	cputime(T2),
	Time is (T2-T1)-(T1-T0).
%	format('~|~t~d~8+ iterations taking ~|~t~d~6+ msec~n', [Count,Time]).   % Original

dobench(Count) :-
	data(Data),
	repeat0(Count),           % repeat/1 is conflict to AZ-Prolog-Builtin-Pred
	(benchmark(Data, _Result) -> true),
	fail.
dobench(_).

dodummy(Count) :-
	data(List),
	repeat0(Count),
	dummy(List,_),
	fail.
dodummy(_).

dummy(_,_).

repeat0(_N).                   % Original is repeat/1 
repeat0(N) :-
	N > 1,
	N1 is N - 1,
	repeat0(N1).

cputime(T) :-
	statistics(runtime, [T, _]).
