:-kanji_mode(_,off).

require(X):- onig_version(_), !.  % for built-in library case.
require(X):- dlib_require(X), !,
  write('Library Loaded: '), onig_version(V), write(V), nl.
require(X):- dlib_get_error_str(S), name(E, S), write(E), nl.

:- require(oniguruma).

test:-
     search_data(Data),
     write('%%%%%%%%%%'),nl,
        puts(Data),nl,
     write('%%%%%%%%%%'),nl,
     go('((P|p)rolog)(....)',Data).

%%%%%%%%%%%%%%%%
go(Pattern,TargetString):-
    onig_pattern_compile(Pattern,REGEX),!,
        onig_make_target_string(TargetString,Target),
          proceed(Pattern,REGEX,0,Target),
        onig_free_target_string(Target),
    onig_pattern_free(REGEX).
    
go(Pattern,_):-
    write('正規表現のパターン指定が不正です'),
    onig_pattern_error_info(Pattern,ERR),write(ERR).

proceed(Pattern,REGEX,end,Target):-!.
proceed(Pattern,REGEX,Start,Target):-
            onig_search_success(REGEX,Target, Start, _,MSTART,MEND,CAPTURES,NEXT),
            write_result(Pattern,MSTART,MEND,CAPTURES,NEXT),
            nl,write('::More?(m) End?(e)'),get(X),X is "m",!,
            proceed(Pattern,REGEX,NEXT,Target).

proceed(Pattern,REGEX,Start,Target).

%%%%%%%%%%%%%

write_result(Pattern,MSTART,MEND,CAPTURES,NEXT):-
    write_listnl(['マッチした位置: ',MSTART]),
    write_listnl(['マッチ終了位置: ',MEND]),
    write_listnl(['次以降検索位置: ',NEXT]),
    write('[取得文字列]'),write(Pattern),nl,
    write_captures(CAPTURES).

write_captures([]):-!.
write_captures([A|L]):-puts(A),nl,write_captures(L).

puts([]):- !.
puts([C|T]):- !,put(C),puts(T).
puts(A):- write(A).

%%%% 検索対象初期値
search_data(
"（1）Prolog言語の知識
AZ-Prologのシンタックスは「DEC-10　Prolog」に準拠していますので、その知識を前提とします。
このマニュアルの「Chapter4・Prolog言語」でもProlog言語について解説をしていますが、Prolog言語を全くご存じ無い方には少々説明が不足かも知れません。そこで、Prolog言語についての入門書を読みながらこのインタープリタを使っていかれることをお奨めします。
Prolog言語の解説は次項の「Prolog言語に関する参考文献」で紹介します。
（2）OSの知識
各OSの立ち上げプロセスを始め、エディタの概念などは最低限知っている必要があります。また、AZ-Prologではコマンドライン・ユーティリティーを実行出来る「system」述語一時的にOSのコマンド・プロンプトレベルに抜けられる「sh」述語とがあります。
これを使用する場合は、用途に応じた知識が必要です。").
