/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% 積み木の世界 Flash/Prolog 版 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

   原典：  高野真著「Prologで学ぶAI手法」(啓学出版１９８８）
   Modify: 稲葉 輝(SOFNEC)

      Prologソースファイル：tumiki.pl  tumiki.dcg
      実行ファイル：  tumiki.cgi（DCG変換、バイトコードコンパイル済）
      実行ファイル作成手順： tumiki_Make_CGI.txt に記述
          \>prolog -s tumiki_Make_CGI.txt

        １）Prolog インタプリタでtumiki.dcg をDCG変換し,tumiki.pl にアペンド
        ２）融合したファイルをバイトコードコンパイル
        ３）ファイルの先頭にCGIのBinへのパスが書く。
            ユーザの環境にあわせて変更のこと

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Flash <=> Prolog インターフェース %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

＜Flash側の画面構成＞

   +------------------------------------+
   |           積木の世界               |
   +------------------------------------+
   |            $                       |　ロボットの手
   |            $                       |
   |            ""                      |
   |                                    |
   |               白黄                 |　赤青白黄のブロック
   |               赤青                 |
   |      ######################        |　机
   +------------------------------------+
   |日本語で命令し積木を動かしてください|
   +------------------------------------+
   |命令：[                        ]<go>|  <== ユーザーの入力エリア&ボタン
   +------------------------------------+    tumiki.cgi?table=赤21青31白22黄32&input=赤い積木を青い積木の上に置け
   |                                    |  <== エラーのときは「わかりません。再入力してください」
   +------------------------------------+      エラーでなくmoveが空のときは、「操作がありません」それ以外は空表示
    [文法ファイル表示]  [プログラム表示]   <== ソース表示ボタン
    puttxt tumiki.dcg    puttxt tumiki.pl  <== 上のボタン押下で起動


＜盤面の表現＞

１）ブロックの配色　赤;青;白;黄　とする。
２）ブロックの位置の座標系(X,Y)

  X--> １２３４
    ５
    ４
    ３
    ２   白黄
    １   赤青
    ↑ --------
    Y  座標系

＜配置表現例＞

  白黄                      　赤 
  赤青                    白　青黄
 ------                   --------
配置１(赤21青31白22黄32) 配置２(赤32青31白11黄41)

＜Flashからの入力＞
input="赤い積木を青い積木の上に置け"         ユーザの入力した命令文
table="赤21青31白22黄32"                     現在の盤面

＜Flashへの出力＞
move=白2211黄3241赤2132&table=赤22青31白11黄41

move: ブロックの移動手順（下記）
      操作する内容がないときは空である。
      例：すでに置いてあるとき、自己撞着文（青い積み木の上に青い積み木をおけ）

table:最終配置 （次のFlashからの出力に利用する）
      入力文解析不能のときは、table=error が出力される。

＜＜例１＞＞
move=白2211黄3241赤2132　は次の手順を並べている。
     1-----2=====3-----

"赤を青の上に置け" の移動手順解

(1)  move 白 from (X=2,Y=2) to (X=1,Y=1)    白を(2,2)から(1,1)へ移動
(2)  move 黄 from (X=3,Y=2) to (X=4,Y=1)    黄を(3,2)から(4,1)へ移動
(3)  move 赤 from (X=2,Y=1) to (X=3,Y=2)    赤を(2,1)から(3,2)へ移動

　１２３　　１２３４　　１２３４　　１２３４
３
２  白黄        黄                      赤
１  赤青    白赤青      白赤青黄    白　青黄
 ---------  --------  ----------    ---------
    Begin   白2211      黄3241      赤2132

＜＜例２＞＞
move=白2211赤2125　は次の手順を並べている。
     1-----2=====

"赤いのをとれ" の移動手順解

(1)  move 白 from (X=2,Y=2) to (X=1,Y=1)    白を(2,2)から(1,1)へ移動
(2)  move 赤 from (X=2,Y=1) to (X=2,Y=5)    赤を(2,1)から(2,5)へ移動

　１２３　　１２３４　　１２３４
５                        赤
４
３
２  白黄        黄          黄    
１  赤青    白赤青      白　青
 ---------  --------  ----------
    Begin   白2211      赤2125
    初期    Step-1      Step-2

注：各ステップの移動のときのみ、ブロックの上にロボットの手を表示する。

（イメージ）

   ||
  ####
 ■■■
 ■■■




test_init:- 
	abolish(obj,3),
	do_ass("赤21青31白22黄32").

test(X):- 
	write('==初期盤面=='),nl,
	write_obj,
	nl,write('move='),
	入力文(Goal,X,[]),
	call(Goal),nl,
	write('==移動後盤面=='),nl,nl,
	write_obj,
	 obj(赤,Xa,Ya),obj(青,Xb,Yb),obj(白,Xc,Yc),obj(黄,Xd,Yd),
	 write_listnl(['&table=',赤,Xa,Ya,青,Xb,Yb,白,Xc,Yc,黄,Xd,Yd]),!.

write_obj:- write_obj(1,5).
write_obj(1,0):- !,write('--------'),nl.
write_obj(5,Y):- !,nl,YY is Y-1,write_obj(1,YY).
write_obj(X,Y):- obj(O,X,Y),!,write(O),XN is X+1,write_obj(XN,Y).
write_obj(X,Y):- write('　'),XN is X+1,write_obj(XN,Y).

write_listnl([]):-!,nl.
write_listnl([A|B]):-write(A),write_listnl(B).

*/

%%%%%%%%%%%%%%%%%%%%%%%%%
%% TopLevel Interface  %%
%%%%%%%%%%%%%%%%%%%%%%%%%

:- publicall.

top_call:- 
	 get_param(input,X),      % 引数で与えられた命令文を取得
	 get_param(table,Y),      % 引数で与えられた現在の盤面を取得
	 name(X,X0),name(Y,Y0),   % 引数を文字列へ変換
	 space_cutter(X0,XX0),    % 空白文字などを除去
	 do_ass(Y0),              % 盤面データを内部DB(ヒープ)へ変換
%	 write('Content-Type: text/html; charset=Shift_JIS'),
	 write('Content-Type: text/html; charset=utf-8'),
	 nl,nl,write('move='),
	 入力文(Goal,XX0,[]),     % 自然言語命令をプランゴールに解釈
	 call(Goal).              % プランゴールの実行

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ブロックの配置情報を内部データベースへ登録 %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
do_ass([]):-!.
do_ass([Obj,P1,P2|L]):-
	P2 =< "9",!,
	Px is P1-"0",Py is P2-"0",name(ObjN,[Obj]),
	assert(obj(ObjN,Px,Py)),
	do_ass(L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 入力文からスペース、句読点を除去する %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
space_cutter([],[]):-!.
space_cutter([A|B],C):- member(A,"。、　"),!,space_cutter(B,C).
space_cutter([A|B],[A|C]):- space_cutter(B,C).

% member(A,[A|_]):-!.
% member(A,[_|L]):-member(A,L).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 命令： on(A,B) pickup(A) putdown putdown_on(A) %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* ************** */
/* AをBの上に置け */
/* ************** */

on(A,A):-!.
on(A,B):-
	A \== B,
	obj(A,_,5),      % 置くブロックが手中にある
	obj(B,Xb,Yb),    % 置かれるブロック
	Ybb is Yb+1,     % その上に別なブロックがない
	\+ (obj(_,Xb,Ybb)),!,
	move(A,Xb,Ybb).  % ただ置く
	
on(A,B):-
	A \== B,!,
	putdown,          % 手中のブロックがあれば下に置く
	on2(A,B).

on2(A,B):-            % 同じX位置にあり指定の順序で重なる
	obj(A,Xa,Ya),
	obj(B,Xa,Yb),
	Ya is Yb+1,!.     % すでに置いてある 

on2(A,B):-            % 同じX位置にあり指定順で重なっていない
	obj(A,Xa,Ya),
	obj(B,Xa,Yb),!,
	(Ya < Yb -> clear(A,'');clear(B,'')),   % 下にある方の上を空ける
	on2(A,B).                               % 

on2(A,B):-
	obj(A,Xa,Ya),
	obj(B,Xb,Yb),!,
	clear(A,Xb),              % それぞれの上を空ける
	clear(B,Xa),
	Yn is Yb+1,
	move(A,Xb,Yn),!.          % Bの上にAを移動する

/* ************** */
/*   Aを取れ      */
/* ************** */
pickup(A):- obj(A,_,5),!.

pickup(A):-
	putdown,
	obj(A,Xa,Ya),
	clear(A,''),
	move(A,Xa,5).

/* ************************** */
/*   それをテーブルに置け     */
/* ************************** */
putdown:-
	obj(O,X,5),!,
	get_space([],Xn,Yn),
	move(O,Xn,Yn).

putdown.

/* *********************** */
/*   それをAの上に置け     */
/* *********************** */
putdown_on(A):-
	obj(O,_,5),
	O \== A,!,
	on(O,A).
putdown_on(A).

/* *********************** */
/*   それをAの下に置け     */
/* *********************** */
putdown_under(A):-
	obj(O,_,5),
	O \== A,!,
	on(A,O).

putdown_under(A).

/* *********************** */
/*   AをBとCの間に置け     */
/* *********************** */
between(A,B,C):-
	A \== B,
	B \== C,
	C \== A,
	obj(B,Xb,Yb),obj(C,Xc,Yc),!,
	(Yb >Yc -> on(A,C),on(B,A);on(A,B),on(C,A)).

between(A,B,C).

/* *********************** */
/*   BとCの間に置け     */
/* *********************** */

between(B,C):-
	obj(A,_,5),
	between(A,B,C),!.

between(B,C).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% ブロックの移動
move(A,X,Y):- obj(A,X,Y),!.
move(A,X,Y):-
	retract(obj(A,X0,Y0)),!,
	assert(obj(A,X,Y)),
    write_list([A,X0,Y0,X,Y]).   % 一手順の出力

%% 指定ブロックの上を空ける
clear(Obj,Not):-
	obj(Obj,X,Y),
	clear(X,4,Y,Not).

clear(X,N,N,_):-!.
clear(X,Y,N,Not):- 
	obj(O,X,Y),!,
	get_space([X,Not],Xn,Yn),
	move(O,Xn,Yn),
	Yx is Y-1,
	clear(X,Yx,N,Not).
clear(X,Y,N,Not):- 
	Yn is Y-1,
	clear(X,Yn,N,Not).

%% 空きスペースを探す
get_space(Nots,Xn,Yn):-
	get_space(1,1,Xn,Yn),\+ member(Xn,Nots).

get_space(5,Ny,X,Y):- !,NNy is Ny+1,get_space(1,NNy,X,Y).
get_space(Nx,Ny,X,Y):-
	obj(_,Nx,Ny),!,NNx is Nx+1,get_space(NNx,Ny,X,Y).
get_space(X,Y,X,Y).

%%%%%%%%%% ぷろぐらむおわり %%%%%%%%%%%%
