%% プログラムの目的　　File の１６進ダンプ
%% コンパイルの方法　　>azpc -p dump.pl /no /e dump
%% 使い方　　　　　　　>dump sazae.sjis 
%% 2010.06 T.Inaba

top_level :-
	fileerrors(_,fail),
	prompt(_,'More(C/R or "n")>'),
	kanji_mode(_,off),
	get_parameter([File]),
	write([File]),
	see(File),get1(X),e_register(0,_,X),
		repeat(N),
			write_100(N,EOF),
	    	(EOF == yes -> true ; ttyget0(110)),
	    !,
	seen.

top_level :- write('Can''t see the file'),nl.

write_100(N,EOF):-
	nl,write('     +00+01+02+03+04+05+06+07+08+09+0A+0B+0C+0D+0E+0F   0123456789ABCDEF'),nl,
	repeat(M),
		write_hex(N),write_hex(M*0'10),write(': '),   % 左欄
		get_1(A),get_16(16,A,L,EOF),                  % 16進ダンプ
		length(L,S),tab(2+(16-S)*3),                  % イメージまでの埋空白
		put_16(L),nl,                                 % イメージ表示
	(EOF == yes -> true ; M is 15),                   % FileEnd or 15 Line
	!.

put_16([]):-!.
put_16([C|L]):- ((C >= 32,C=<127)-> put(C);put(" ")),put_16(L).

get_16(_,end_of_file,[],  yes):-!.
get_16(1,C, [C],  no):-!,write_hex(C),tab(1).
get_16(N,C, [C|L],YN):-  write_hex(C),tab(1),NN is N-1,get_1(X),get_16(NN,X,L,YN).

write_hex(X) :-  write_hex1(X//16), write_hex1(X mod 16).

write_hex1(X) :- X<10, !, X0 is X,write(X0).
write_hex1(X) :- Y is "A"+X-10, put(Y).

get_1(Y):- get1(X),!,e_register(0,Y,X).
get_1(end_of_file).
